-- MySQL dump 10.9
--
-- Host: localhost    Database: game
-- ------------------------------------------------------
-- Server version	4.1.11

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `content`
--

DROP TABLE IF EXISTS `content`;
CREATE TABLE `content` (
  `content_id` int(11) NOT NULL auto_increment,
  `content_module` varchar(25) NOT NULL default '',
  `content_column` int(11) NOT NULL default '0',
  `content_active` char(1) NOT NULL default '',
  `content_display` int(11) NOT NULL default '10',
  `content_level` int(11) NOT NULL default '0',
  PRIMARY KEY  (`content_id`),
  KEY `key_module` (`content_module`),
  CONSTRAINT `content_ibfk_1` FOREIGN KEY (`content_module`) REFERENCES `modules` (`module_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `dataset_model`
--

DROP TABLE IF EXISTS `dataset_model`;
CREATE TABLE `dataset_model` (
  `datasetName` varchar(255) NOT NULL default '0',
  `modelId` bigint(20) NOT NULL default '0',
  `graphURI` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`modelId`,`datasetName`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `datasets`
--

DROP TABLE IF EXISTS `datasets`;
CREATE TABLE `datasets` (
  `datasetName` varchar(255) NOT NULL default '',
  `defaultModelUri` varchar(255) NOT NULL default '0',
  PRIMARY KEY  (`datasetName`),
  KEY `datasetName` (`datasetName`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `errorcodes`
--

DROP TABLE IF EXISTS `errorcodes`;
CREATE TABLE `errorcodes` (
  `error_id` char(3) NOT NULL default '',
  `error_name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`error_id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `game_user`
--

DROP TABLE IF EXISTS `game_user`;
CREATE TABLE `game_user` (
  `user_id` float NOT NULL auto_increment,
  `user_lastname` varchar(100) NOT NULL default '',
  `user_firstname` varchar(100) NOT NULL default '',
  `user_middle` varchar(100) NOT NULL default '',
  `user_dob` date NOT NULL default '0000-00-00',
  `user_gender` char(1) NOT NULL default '',
  `user_role` varchar(5) NOT NULL default '',
  `user_admin` char(1) NOT NULL default '',
  `user_login` varchar(10) NOT NULL default '',
  `user_password` varchar(32) NOT NULL default '',
  `user_lang` varchar(10) NOT NULL default 'english',
  `user_email` varchar(100) default '',
  `user_cellular` varchar(100) NOT NULL default '',
  `user_pin` varchar(4) NOT NULL default '',
  `user_active` char(1) NOT NULL default '',
  PRIMARY KEY  (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `location`
--

DROP TABLE IF EXISTS `location`;
CREATE TABLE `location` (
  `location_id` varchar(10) NOT NULL default '',
  `location_name` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`location_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `m_lib_penncode`
--

DROP TABLE IF EXISTS `m_lib_penncode`;
CREATE TABLE `m_lib_penncode` (
  `treebank_id` varchar(10) NOT NULL default '',
  `treebank_name` varchar(100) NOT NULL default '',
  `treebank_example` varchar(100) default NULL,
  `treebank_status` char(1) default 'Y',
  `treebank_highlight_color` varchar(10) default NULL,
  PRIMARY KEY  (`treebank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `m_textlab_abbreviations`
--

DROP TABLE IF EXISTS `m_textlab_abbreviations`;
CREATE TABLE `m_textlab_abbreviations` (
  `document_id` varchar(100) NOT NULL default '',
  `abbrev_term` varchar(20) NOT NULL default '',
  `abbrev_context` varchar(100) default NULL,
  `treebank_id` varchar(10) NOT NULL default '',
  PRIMARY KEY  (`document_id`,`abbrev_term`,`treebank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `m_textlab_concepts`
--

DROP TABLE IF EXISTS `m_textlab_concepts`;
CREATE TABLE `m_textlab_concepts` (
  `document_id` varchar(100) NOT NULL default '',
  `concept_id` varchar(10) NOT NULL default '',
  `key_terms` text,
  `relevance` char(1) default NULL,
  PRIMARY KEY  (`document_id`,`concept_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `m_textlab_dictionary`
--

DROP TABLE IF EXISTS `m_textlab_dictionary`;
CREATE TABLE `m_textlab_dictionary` (
  `word_id` float NOT NULL auto_increment,
  `word_ngram` varchar(255) default '',
  `word_metaphone` varchar(25) default '',
  `word_str` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`word_id`),
  UNIQUE KEY `word_str` (`word_str`),
  KEY `word_metaphone` (`word_metaphone`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `m_textlab_document`
--

DROP TABLE IF EXISTS `m_textlab_document`;
CREATE TABLE `m_textlab_document` (
  `document_id` varchar(100) NOT NULL default '',
  `province_code` varchar(5) NOT NULL default 'UNK',
  `transcription_code` char(1) NOT NULL default 'H',
  `word_count` int(11) NOT NULL default '0',
  `concept_count` int(11) NOT NULL default '0',
  `negation_count` int(11) NOT NULL default '0',
  `raw_text` text,
  `input1` text,
  `input2` text,
  `cleaned_text` text,
  `spellchecked_text` text,
  `missedspellerrors_terms` text,
  `postagged_text` text,
  `missedpostagged_terms` text,
  `phrased_text` text,
  `cuitagged_text` text,
  `missedcuitagged_terms` text,
  `negation_terms` text,
  `missednegated_terms` text,
  `concept_terms` text,
  `document_log` text,
  `partition_status` char(1) default NULL,
  `train_text` text,
  PRIMARY KEY  (`document_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `m_textlab_ignorelist`
--

DROP TABLE IF EXISTS `m_textlab_ignorelist`;
CREATE TABLE `m_textlab_ignorelist` (
  `ignore_str` varchar(50) NOT NULL default '',
  PRIMARY KEY  (`ignore_str`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `m_textlab_negation`
--

DROP TABLE IF EXISTS `m_textlab_negation`;
CREATE TABLE `m_textlab_negation` (
  `document_id` varchar(100) NOT NULL default '',
  `negation_term` varchar(20) NOT NULL default '',
  `negation_context` varchar(100) default NULL,
  `treebank_id` varchar(10) NOT NULL default '',
  PRIMARY KEY  (`document_id`,`negation_term`,`treebank_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `m_textlab_nounphrase`
--

DROP TABLE IF EXISTS `m_textlab_nounphrase`;
CREATE TABLE `m_textlab_nounphrase` (
  `phrase_id` float NOT NULL auto_increment,
  `phrase_str` varchar(50) NOT NULL default '',
  `phrase_tagged` varchar(70) default '',
  PRIMARY KEY  (`phrase_id`),
  UNIQUE KEY `phrase_str` (`phrase_str`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `models`
--

DROP TABLE IF EXISTS `models`;
CREATE TABLE `models` (
  `modelID` bigint(20) NOT NULL default '0',
  `modelURI` varchar(255) NOT NULL default '',
  `baseURI` varchar(255) default '',
  PRIMARY KEY  (`modelID`),
  UNIQUE KEY `m_modURI_idx` (`modelURI`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `module_dependencies`
--

DROP TABLE IF EXISTS `module_dependencies`;
CREATE TABLE `module_dependencies` (
  `module_id` varchar(25) NOT NULL default '',
  `req_module` varchar(25) NOT NULL default '',
  PRIMARY KEY  (`module_id`,`req_module`),
  CONSTRAINT `foreign` FOREIGN KEY (`module_id`) REFERENCES `modules` (`module_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `module_menu`
--

DROP TABLE IF EXISTS `module_menu`;
CREATE TABLE `module_menu` (
  `menu_id` int(11) NOT NULL auto_increment,
  `module_id` varchar(25) NOT NULL default '0',
  `menu_cat` varchar(10) NOT NULL default '',
  `menu_title` varchar(20) NOT NULL default '',
  `menu_rank` int(11) NOT NULL default '0',
  `menu_visible` char(1) NOT NULL default 'Y',
  `menu_action` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`menu_id`,`module_id`),
  UNIQUE KEY `ukey_modulemenu` (`module_id`,`menu_action`),
  KEY `key_module` (`module_id`),
  CONSTRAINT `module_menu_ibfk_1` FOREIGN KEY (`module_id`) REFERENCES `modules` (`module_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `module_menu_location`
--

DROP TABLE IF EXISTS `module_menu_location`;
CREATE TABLE `module_menu_location` (
  `location_id` varchar(10) NOT NULL default '',
  `module_id` varchar(25) NOT NULL default '',
  `menu_id` int(11) NOT NULL default '0',
  PRIMARY KEY  (`location_id`,`menu_id`,`module_id`),
  KEY `key_menu` (`menu_id`),
  KEY `key_module` (`module_id`),
  KEY `key_location` (`location_id`),
  CONSTRAINT `module_menu_location_ibfk_1` FOREIGN KEY (`module_id`) REFERENCES `modules` (`module_id`) ON DELETE CASCADE,
  CONSTRAINT `module_menu_location_ibfk_2` FOREIGN KEY (`location_id`) REFERENCES `location` (`location_id`) ON DELETE CASCADE,
  CONSTRAINT `module_menu_location_ibfk_3` FOREIGN KEY (`menu_id`) REFERENCES `module_menu` (`menu_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `module_menu_permissions`
--

DROP TABLE IF EXISTS `module_menu_permissions`;
CREATE TABLE `module_menu_permissions` (
  `module_id` varchar(25) NOT NULL default '',
  `menu_id` float NOT NULL default '0',
  `user_id` float NOT NULL default '0',
  PRIMARY KEY  (`module_id`,`menu_id`,`user_id`),
  KEY `key_module` (`module_id`),
  KEY `key_menu` (`menu_id`),
  KEY `key_user` (`user_id`),
  CONSTRAINT `module_menu_permissions_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `game_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `module_permissions`
--

DROP TABLE IF EXISTS `module_permissions`;
CREATE TABLE `module_permissions` (
  `module_id` varchar(25) NOT NULL default '0',
  `user_id` float NOT NULL default '0',
  PRIMARY KEY  (`module_id`,`user_id`),
  KEY `key_module` (`module_id`),
  KEY `key_user` (`user_id`),
  CONSTRAINT `module_permissions_ibfk_1` FOREIGN KEY (`module_id`) REFERENCES `modules` (`module_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `module_user_location`
--

DROP TABLE IF EXISTS `module_user_location`;
CREATE TABLE `module_user_location` (
  `location_id` varchar(10) NOT NULL default '',
  `user_id` float NOT NULL default '0',
  PRIMARY KEY  (`location_id`,`user_id`),
  KEY `key_user` (`user_id`),
  KEY `key_location` (`location_id`),
  CONSTRAINT `module_user_location_ibfk_1` FOREIGN KEY (`location_id`) REFERENCES `location` (`location_id`) ON DELETE CASCADE,
  CONSTRAINT `module_user_location_ibfk_2` FOREIGN KEY (`user_id`) REFERENCES `game_user` (`user_id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `modules`
--

DROP TABLE IF EXISTS `modules`;
CREATE TABLE `modules` (
  `module_id` varchar(25) NOT NULL default '',
  `module_init` char(1) NOT NULL default 'N',
  `module_version` varchar(25) default '',
  `module_desc` text NOT NULL,
  `module_author` varchar(50) NOT NULL default '',
  `module_name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`module_id`),
  UNIQUE KEY `ukey_modules` (`module_name`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `namespaces`
--

DROP TABLE IF EXISTS `namespaces`;
CREATE TABLE `namespaces` (
  `modelID` bigint(20) NOT NULL default '0',
  `namespace` varchar(255) NOT NULL default '',
  `prefix` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`modelID`,`namespace`),
  KEY `n_mod_idx` (`modelID`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `role`
--

DROP TABLE IF EXISTS `role`;
CREATE TABLE `role` (
  `role_id` varchar(10) NOT NULL default '',
  `role_dataaccess` char(3) NOT NULL default '',
  `role_name` varchar(100) NOT NULL default '',
  PRIMARY KEY  (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

--
-- Table structure for table `statements`
--

DROP TABLE IF EXISTS `statements`;
CREATE TABLE `statements` (
  `modelID` bigint(20) NOT NULL default '0',
  `subject` varchar(255) NOT NULL default '',
  `predicate` varchar(255) NOT NULL default '',
  `object` text,
  `l_language` varchar(255) default '',
  `l_datatype` varchar(255) default '',
  `subject_is` char(1) NOT NULL default '',
  `object_is` char(1) NOT NULL default '',
  KEY `s_mod_idx` (`modelID`),
  KEY `s_sub_pred_idx` (`subject`(200),`predicate`(200)),
  KEY `s_obj_idx` (`object`(250))
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

--
-- Table structure for table `terms`
--

DROP TABLE IF EXISTS `terms`;
CREATE TABLE `terms` (
  `termid` varchar(50) NOT NULL default '',
  `languageid` varchar(10) NOT NULL default '',
  `langtext` text,
  `remarks` text,
  `translationof` varchar(50) default NULL,
  `module_id` varchar(25) NOT NULL default '',
  `isenglish` char(1) NOT NULL default 'Y',
  PRIMARY KEY  (`termid`,`languageid`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

