<?
class textlab extends module {

    // Author: Herman Tolentino MD
    // NLP Project 2005
    //
    // IMPORTANT: This module makes extensive use of the UMLS Knowledge Sources
    //

    function textlab() {
        //
        // do not forget to update version
        //
        $this->author = 'Herman Tolentino MD';
        $this->version = "0.1-".date("Y-m-d");
        $this->module = "textlab";
        $this->description = "AEFI Module - Text Lab";
        // 0.1: BEGIN
    }

    // --------------- STANDARD MODULE FUNCTIONS ------------------

    function init_deps() {
    //
    // insert dependencies in module_dependencies
    //
        module::set_dep($this->module, "module");
        module::set_dep($this->module, "tagger");
        module::set_dep($this->module, "spelling");
        module::set_dep($this->module, "umlstools");
    }

    function init_lang() {
    //
    // insert necessary language directives
    //
        module::set_lang("FTITLE_RAWTEXT_FORM", "english", "RAW TEXT FORM", "Y");
        module::set_lang("LBL_DOCUMENT_ID", "english", "Document ID", "Y");
        module::set_lang("LBL_PROVINCE", "english", "Province", "Y");
        module::set_lang("LBL_RAWTEXT", "english", "Raw Text", "Y");
        module::set_lang("LBL_NEGATION_TERMS", "english", "Negation Terms", "Y");
        module::set_lang("FTITLE_RAWTEXT_LIST", "english", "RAW TEXT LIST", "Y");
        module::set_lang("THEAD_DOCUMENT_ID", "english", "DOCUMENT ID", "Y");
        module::set_lang("THEAD_PROVINCE", "english", "PROVINCE", "Y");
        module::set_lang("THEAD_DOCUMENT_TEXT", "english", "RAW TEXT", "Y");
        module::set_lang("THEAD_PARTITION", "english", "PARTITION", "Y");
        module::set_lang("LBL_TAGGEDTEXT", "english", "Tagged Text", "Y");
        module::set_lang("FTITLE_TRANSFORM_FORM", "english", "TEXT TRANSFORM", "Y");
        module::set_lang("LBL_DOCUMENT_DETAILS", "english", "Document Details", "Y");
        module::set_lang("LBL_CLEANED_TEXT", "english", "Cleaned Text", "Y");
        module::set_lang("LBL_TAGGED_TEXT", "english", "Tagged Text", "Y");
        module::set_lang("LBL_CONCEPT_TAGGED_TEXT", "english", "CONCEPT-TAGGED TEXT", "Y");
        module::set_lang("LBL_TRANSCRIPTION", "english", "Transcription Code", "Y");
        module::set_lang("LBL_SPELLCHECKED_TEXT", "english", "SPELL-CHECKED TEXT", "Y");
        module::set_lang("LBL_NOUN_PHRASES", "english", "NOUN PHRASES", "Y");
        module::set_lang("LBL_CUITAGGED_TEXT", "english", "CONCEPT-TAGGED TEXT", "Y");
        module::set_lang("LBL_DIFF_TEXT", "english", "TEXT DIFFERENCE", "Y");
        module::set_lang("LBL_INPUT1_TEXT", "english", "TEXT INPUT 1", "Y");
        module::set_lang("LBL_INPUT2_TEXT", "english", "TEXT INPUT 2", "Y");
        module::set_lang("LBL_NEGATED_CONCEPTS", "english", "NEGATED CONCEPTS", "Y");
        module::set_lang("LBL_FILTERED_TEXT", "english", "FILTERED TEXT", "Y");
        module::set_lang("LBL_LOAD_TABLE", "english", "LOAD TABLE", "Y");
        module::set_lang("LBL_DUMP_TABLE", "english", "DUMP TABLE", "Y");
        module::set_lang("INSTR_PICK_RAW_SRC", "english", "SELECT INPUT TO BECOME RAW DATA", "Y");
        module::set_lang("LBL_DOCUMENT_ENTROPY", "english", "DOCUMENT ENTROPY", "Y");
        module::set_lang("LBL_DOCUMENT_GRAPHS", "english", "DOCUMENT GRAPHS", "Y");
        module::set_lang("LBL_CUITAGGED_TEXT_PREDICTED", "english", "CONCEPT TAGGING PREDICTED", "Y");

    }

    function init_menu() {
        if (func_num_args()>0) {
            $arg_list = func_get_args();
            $module_id = $arg_list[0];
        }
        module::set_menu($this->module, "Raw Text", "PROCESSING", "_rawtext");
        module::set_menu($this->module, "Transform", "PROCESSING", "_transform");
        module::set_menu($this->module, "Corpus Summary", "PROCESSING", "_corpus_summary");
        module::set_menu($this->module, "Dump Data", "PROCESSING", "_dumpdata");
        module::set_menu($this->module, "Load Data", "PROCESSING", "_loaddata");
        module::set_menu($this->module, "Batch Mode", "PROCESSING", "_batchmode");

        // put in more details
        module::set_detail($this->description, $this->version, $this->author, $this->module);
    }

    function init_stats() {
    }

    function init_help() {
    }

    function init_sql() {
        if (func_num_args()>0) {
            $arg_list = func_get_args();
            $module_id = $arg_list[0];
        }

        module::execsql("CREATE TABLE `m_textlab_document` (".
            "`document_id` varchar(100) NOT NULL,".
            "`province_code` varchar(5) NOT NULL default 'UNK',".
            "`transcription_code` char(1) NOT NULL default 'H',".
            "`word_count` integer NOT NULL default 0,".
            "`concept_count` integer NOT NULL default 0,".
            "`negation_count` integer NOT NULL default 0,".
            "`raw_text` text,".
            "`input1` text,".
            "`input2` text,".
            "`cleaned_text` text, ".
            "`spellchecked_text` text, ".
            "`postagged_text` text,".
            "`phrased_text` text,".
            "`cuitagged_text` text,".
            "`cuitagged_text_predicted` text,".
            "`negation_terms` text,".
            "`filtered_text` text,".
            "`partition_status` char(1),".
            "`train_text` text,".
            "PRIMARY KEY  (`document_id`)".
            ") TYPE=InnoDB; ");

        module::execsql("CREATE TABLE `m_textlab_stats` (".
            "`document_id` varchar(100) NOT NULL default '',".
            "`transform_stage varchar(10) not null`".
            "`token_count` int NOT NULL default 0,".
            "`sentence_count` int NOT NULL default 0,".
            "`phrase_count` int NOT NULL default 0,".
            "`concept_count` int NOT NULL default 0,".
            "PRIMARY KEY  (`document_id`,`transform_stage`),".
            "FOREIGN KEY (`document_id`) REFERENCES `m_textlab_document` (`document_id`) ON DELETE CASCADE".
            ") TYPE=InnoDB; ");

        module::execsql("CREATE TABLE `m_textlab_bayes` (".
            "`term` varchar(100) NOT NULL default '',".
            "`treebank_id` varchar(5) NOT NULL default '',".
            "`concept_id` varchar(10) NOT NULL default '',".
            "`frequency` int(11) NOT NULL default '0',".
            "`probability` float NOT NULL default '0',".
            "PRIMARY KEY  (`term`,`treebank_id`,`concept_id`)".
            ") ENGINE=MyISAM; ");

        module::execsql("CREATE TABLE `m_textlab_bigrams` (".
            "`concept1_id` varchar(10) NOT NULL default '',".
            "`concept2_id` varchar(10) NOT NULL default '',".
            "`distance` int(11) NOT NULL default '0',".
            "`frequency` int(11) NOT NULL default '0',".
            "PRIMARY KEY  (`concept1_id`,`concept2_id`)".
            ") ENGINE=MyISAM");

        module::execsql("CREATE TABLE `m_textlab_terms` (".
            "`document_id` varchar(100) NOT NULL default '',".
            "`term` varchar(100) NOT NULL default '',".
            "`concept_id` varchar(10) default '',".
            "`treebank_id` varchar(5) default '',".
            "`negated` char(1) default 'N',".
            "`frequency` int default 0,".
            "`preferred` char(1) default '',".
            "PRIMARY KEY  (`document_id`,`term`,`concept_id`,`treebank_id`),".
            "FOREIGN KEY (`document_id`) REFERENCES `m_textlab_document` (`document_id`) ON DELETE CASCADE".
            ") TYPE=InnoDB; ");

        // use this table for bayesian inference for concepts
        module::execsql("CREATE TABLE `m_textlab_cooccurrence` (".
            "`document_id` varchar(100) NOT NULL default '',".
            "`concept_id_1` varchar(10) NOT NULL default '',".
            "`concept_id_2` varchar(10) default '',".
            "PRIMARY KEY  (`document_id`, `concept_id_1`,`concept_id_2`),".
            "FOREIGN KEY (`document_id`) REFERENCES `m_textlab_document` (`document_id`) ON DELETE CASCADE".
            ") TYPE=InnoDB; ");

    }

    function drop_tables() {

        module::execsql("set FOREIGN_KEY_CHECKS=0`;");
        module::execsql("DROP TABLE `m_textlab_terms`;");
        module::execsql("DROP TABLE `m_textlab_stats`;");
        module::execsql("DROP TABLE `m_textlab_cooccurrence`;");
        module::execsql("DROP TABLE `m_textlab_document`;");
        module::execsql("DROP TABLE `m_textlab_bayes`;");
        module::execsql("set FOREIGN_KEY_CHECKS=1`;");

    }

    // --------------- CUSTOM MODULE FUNCTIONS ------------------


    function _rawtext () {
        if (func_num_args()>0) {
            $arg_list = func_get_args();
            $menu_id = $arg_list[0];
            $post_vars = $arg_list[1];
            $get_vars = $arg_list[2];
            $validuser = $arg_list[3];
            $isadmin = $arg_list[4];
            //print_r($arg_list);
        }
        // always check dependencies
        if ($exitinfo = $this->missing_dependencies('module')) {
            return print($exitinfo);
        }
        if ($exitinfo = $this->missing_dependencies('tagger')) {
            return print($exitinfo);
        }
        if ($post_vars["submittext"]) {
            textlab::process_rawtext($menu_id,$post_vars,$get_vars);
        }

        //textlab::form_rawtext($menu_id,$post_vars,$get_vars);
        //textlab::display_rawtext($menu_id,$post_vars,$get_vars);

        print "<table width='650' cellpadding='4' cellspacing='0'>";
        print "<tr valign='top'><td colspan='2'>";
        print "<span class='library'>".FTITLE_RAWTEXT_FORM."</span><br><br>";
        print "</td></tr>";
        print "<tr valign='top'><td bgcolor='#CCFFCC' width='25%'>";
        print textlab::display_rawtext($menu_id, $post_vars, $get_vars);
        print "</td><td>";
        textlab::form_rawtext($menu_id,$post_vars,$get_vars);
        print "</td></tr>";
        print "</table>";

    }

    function form_rawtext() {
        if (func_num_args()) {
            $arg_list = func_get_args();
            $menu_id = $arg_list[0];
            $post_vars = $arg_list[1];
            $get_vars = $arg_list[2];

            if ($get_vars["document_id"]) {
                $sql = "select document_id, province_code, partition_status, input1, input2, raw_text, transcription_code ".
                       "from m_textlab_document where document_id = '".$get_vars["document_id"]."'";
                if ($result = mysql_query($sql)) {
                    if (mysql_num_rows($result)) {
                        $textlab = mysql_fetch_array($result);
                        //print_r($textlab);
                    }
                }
            }
        }
        print "<table width='500'>";
        print "<form action = '".$_SERVER["SELF"]."?page=PROCESSING&menu_id=".$get_vars["menu_id"].($get_vars["document_id"]?"&document_id=".$get_vars["document_id"]:"")."' name='form_rawtext' method='post'>";
        print "<tr valign='top'><td>";
        print "<span class='boxtitle'>".LBL_DOCUMENT_ID."</span><br> ";
        if ($textlab["document_id"]) {
            print "<span class='library'>".$textlab["document_id"]."</span><br>";
        }
        print "<input type='text' class='textbox' size='20' maxlength='20' name='document_id' value='".($textlab["document_id"]?$textlab["document_id"]:$post_vars["document_id"])."' ".($textlab["document_id"]?"disabled":"")." style='border: 1px solid #000000'><br>";
        print "</td></tr>";
        print "<tr valign='top'><td>";
        print "<span class='boxtitle'>".LBL_TRANSCRIPTION."</span><br> ";
        print "<input type='radio' name='transcription_code' value='H' ".(($textlab["transcription_code"]?$textlab["transcription_code"]:$post_vars["transcription_code"])=="H"?"checked":"")."'> Handwritten<br>";
        print "<input type='radio' name='transcription_code' value='T' ".(($textlab["transcription_code"]?$textlab["transcription_code"]:$post_vars["transcription_code"])=="T"?"checked":"")."'> Typed<br>";
        print "</td></tr>";
        if ($textlab["document_id"]) {
            print "<tr valign='top'><td>";
            print "<span class='boxtitle'>".LBL_RAWTEXT."</span><br>";
            if ($post_vars["submittext"]=="Edit Raw Data") {
                print "<textarea class='textbox' rows='10' cols='60' name='raw_text' style='border: 1px solid #000000'>";
                print ($textlab["raw_text"]?$textlab["raw_text"]:"");
                print "</textarea><br>";
            } else {
                if ($textlab["document_id"] && strlen(trim($textlab["raw_text"]))==0) {
                    print "<span class='tinylight'><i>".INSTR_PICK_RAW_SRC."</i></span><br> ";
                    print "<input type='radio' name='raw_source' value='1' ".($textlab["transcription_code"]=="H"?"checked":"")."'> Input 1<br>";
                    print "<input type='radio' name='raw_source' value='2' ".($textlab["transcription_code"]=="T"?"checked":"")."'> Input 2<br><br>";
                    print "<input type='submit' value = 'Copy Input to Raw Data' class='smallbutton' name='submittext' style='border: 1px solid #000000'> ";
                    print "<input type='submit' value = 'Edit Raw Data' class='smallbutton' name='submittext' style='border: 1px solid #000000'><br><br>";
                } else {
                    print $textlab["raw_text"];
                }
            }
            print "</td></tr>";
        }
        print "<tr valign='top'><td>";

        print "<table width='100%' style='background-color: #FFFFC0' cellpadding='3' cellspacing='0'><tr><td>";
        print "<span class='boxtitle'>".LBL_INPUT1_TEXT."</span><br> ";
        if ($post_vars["submittext"]=="Edit Input 1") {
            print "<textarea class='textbox' rows='10' cols='60' name='input1_text' style='border: 1px solid #000000'>";
            print ($textlab["input1"]?$textlab["input1"]:$post_vars["input1_text"]);
            print "</textarea><br>";
        } else {
            if ($textlab["input1"]) {
                print $textlab["input1"]."<br><br>";
            } else {
                print "<font color='red'>No text</font><br><br>";
            }
            print "<input type='submit' value = 'Edit Input 1' class='smallbutton' name='submittext' style='border: 1px solid #000000'><br>";
        }
        print "</td></tr></table>";

        print "</td></tr>";
        print "<tr valign='top'><td>";

        print "<table width='100%' style='background-color: #C0C0FF' cellpadding='3' cellspacing='0'><tr><td>";
        print "<span class='boxtitle'>".LBL_INPUT2_TEXT."</span><br> ";
        if ($post_vars["submittext"]=="Edit Input 2") {
            print "<textarea class='textbox' rows='10' cols='60' name='input2_text' style='border: 1px solid #000000'>";
            print $textlab["input2"];
            print "</textarea><br>";
        } else {
            if ($textlab["input2"]) {
                print $textlab["input2"]."<br><br>";
            } else {
                print "<font color='red'>No text</font><br><br>";
            }
            print "<input type='submit' value = 'Edit Input 2' class='smallbutton' name='submittext' style='border: 1px solid #000000'><br>";
        }
        print "</td></tr></table>";

        print "</td></tr>";
        print "<tr valign='top'><td>";
        print "<span class='boxtitle'>".LBL_DIFF_TEXT."</span><br> ";
        if ($textlab["input1"] && $textlab["input2"]) {
            print "<span class='tinylight'><i>IMPORTANT: This compares database entries for input 1 and input 2 text.</i></span><br><br>";
            $text1=trim($textlab["input1"]);
            $text2=trim($textlab["input2"]);
            $nl = '#**!)@#';
            $diff = textlab::inline_diff($text1, $text2, $nl);
            print '<style>del{background:#fcc}ins{background:#cfc}</style>'.$diff."\n";
        } else {
            print "<font color='red'>Input 1 and Input 2 required for DIFF.</font>";
        }
        print "</td></tr>";
        print "<tr><td><br>";
        if ($get_vars["document_id"] or $textlab["document_id"]) {
            print "<input type='hidden' name='document_id' value='".($get_vars["document_id"]?$get_vars["document_id"]:$textlab["document_id"])."'>";
            print "<input type='hidden' name='raw_text' value='".$textlab["raw_text"]."'>";
            print "<input type='submit' value = 'Update' class='textbox' name='submittext' style='border: 1px solid #000000'> ";
            print "<input type='submit' value = 'Clear Raw Text' class='textbox' name='submittext' style='border: 1px solid #000000'> ";
            print "<input type='submit' value = 'Delete' class='textbox' name='submittext' style='border: 1px solid #000000'> ";;
            print "<input type='submit' value = 'New Text' class='textbox' name='submittext' style='border: 1px solid #000000'> ";
        } else {
            print "<input type='submit' value = 'Add Text' class='textbox' name='submittext' style='border: 1px solid #000000'> ";
            print "<input type='submit' value = 'Cancel' class='textbox' name='submittext' style='border: 1px solid #000000'> ";
        }
        print "</td></tr>";
        print "</form>";
        print "</table><br>";
    }

    function process_rawtext() {
        if (func_num_args()) {
            $arg_list = func_get_args();
            $menu_id = $arg_list[0];
            $post_vars = $arg_list[1];
            $get_vars = $arg_list[2];
            //print_r($arg_list);
        }
        switch($post_vars["submittext"]) {
        case "New Text":
            header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]);
            break;
        case "Copy Input to Raw Data":
            if ($post_vars["document_id"] && $post_vars["raw_source"]) {
                if ($post_vars["raw_source"]==1) {
                    $sql = "update m_textlab_document set ".
                           "raw_text = input1 ".
                           "where document_id = '".$post_vars["document_id"]."'";
                } else {
                    $sql = "update m_textlab_document set ".
                           "raw_text = input2 ".
                           "where document_id = '".$post_vars["document_id"]."'";
                }
                if ($result = mysql_query($sql) or die(mysql_errno().": ".mysql_error())) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$get_vars["document_id"]);
                }
            }
            break;

        case "Clear Raw Text":
            if ($post_vars["document_id"]) {
                print $sql = "update m_textlab_document set ".
                       "raw_text = '' ".
                       "where document_id = '".$post_vars["document_id"]."'";
                if ($result = mysql_query($sql) or die(mysql_errno().": ".mysql_error())) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$get_vars["document_id"]);
                }
            }
            break;

        case "Add Text":
            if ($post_vars["document_id"] && ($post_vars["input1_text"] || $post_vars["input2_text"])) {
                $partition = textlab::data_partition();
                $sql = "insert into m_textlab_document (document_id, input1, input2, partition_status, transcription_code) ".
                       "values ('".strtoupper($post_vars["document_id"])."', '".$post_vars["input1_text"]."', ".
                       "'".$post_vars["input2_text"]."', '$partition', '".$post_vars["transcription_code"]."')";
                if ($result = mysql_query($sql) or die(mysql_errno().": ".mysql_error())) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$post_vars["document_id"]);
                }
            }
            break;
        case "Update":
            if ($post_vars["document_id"] && ($post_vars["input1_text"] || $post_vars["input2_text"])) {
                if ($post_vars["input1_text"]) {
                    $sql = "update m_textlab_document set ".
                           "input1 = '".$post_vars["input1_text"]."' ".
                           "where document_id = '".$post_vars["document_id"]."'";
                } else {
                    $sql = "update m_textlab_document set ".
                           "input2 = '".$post_vars["input2_text"]."' ".
                           "where document_id = '".$post_vars["document_id"]."'";
                }
                if ($result = mysql_query($sql)) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$get_vars["document_id"]);
                }
            }
            break;
        case "Delete":
            if (module::confirm_delete($menu_id, $post_vars, $get_vars)) {
                $sql = "delete from m_textlab_document where document_id = '".$post_vars["document_id"]."'";
                if ($result = mysql_query($sql)) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]);
                }
            } else {
                if ($post_vars["confirm_delete"]=="No") {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]);
                }
            }
            break;
        case "Cancel":
            header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]);
            break;
        }
    }

    function _dumpdata() {

        if (func_num_args()) {
            $arg_list = func_get_args();
            $menu_id = $arg_list[0];
            $post_vars = $arg_list[1];
            $get_vars = $arg_list[2];
        }

        if ($post_vars["submitdump"] == "Dump Table") {
            switch ($post_vars["dump_table"]) {
            case "DOC":
                $filename = date("Ymd-His")."-document.sql";
                $commandstring = "mysqldump -u root game m_textlab_document m_textlab_terms m_textlab_bigrams > ".GAME_DUMP_DIR."/$filename";
                header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]);
                break;

            case "DIC":
                $filename = date("Ymd-His")."-dictionary.sql";
                $commandstring = "mysqldump -u root game m_spelling_dictaux m_spelling_ignorelist > ".GAME_DUMP_DIR."/$filename";
                header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]);
                break;

            }
            if ($handle = popen($commandstring, "r")) {
                print "<font color='red'>Data dump created.</font>";
            }
        }
        print "<table width='500'>";
        print "<form action = '".$_SERVER["SELF"]."?page=PROCESSING&menu_id=".$get_vars["menu_id"].($get_vars["document_id"]?"&document_id=".$get_vars["document_id"]:"")."' name='form_dumpdata' method='post'>";
        print "<tr valign='top'><td>";
        print "<span class='boxtitle'>".LBL_DUMP_TABLE."</span><br><br> ";
        print "<input type='radio' name='dump_table' value='DOC' > Documents<br>";
        print "<input type='radio' name='dump_table' value='DIC' > Dictionary<br>";
        print "</td></tr>";
        print "<tr><td><br>";
        print "<input type='submit' value = 'Dump Table' class='textbox' name='submitdump' style='border: 1px solid #000000'> ";
        print "<input type='submit' value = 'Cancel' class='textbox' name='submitdump' style='border: 1px solid #000000'> ";
        print "</td></tr>";
        print "</form>";
        print "</table><br>";

        if (is_dir(GAME_DUMP_DIR)) {
            if ($h = opendir(GAME_DUMP_DIR)) {
                while (($file = readdir($h)) !== false ) {
                    if ($file<>"." && $file<>"..") {
                        print "<a href='".GAME_DUMP_DIR."/$file'>$file</a><br>";
                    }
                }
                closedir($h);
            }
        }
    }

    function _loaddata() {

        if (func_num_args()) {
            $arg_list = func_get_args();
            $menu_id = $arg_list[0];
            $post_vars = $arg_list[1];
            $get_vars = $arg_list[2];
        }

        if ($post_vars["submitload"] == "Load Table") {
            if ($post_vars["load_table"]) {
                $filename = $post_vars["load_table"];
                $commandstring = "mysql -u root game < ".GAME_DUMP_DIR."/$filename";
                if ($handle = popen($commandstring, "r")) {
                    print "<font color='red'>Data loaded.</font>";
                }
            }
        }
        print "<table width='500'>";
        print "<form action = '".$_SERVER["SELF"]."?page=PROCESSING&menu_id=".$get_vars["menu_id"].($get_vars["document_id"]?"&document_id=".$get_vars["document_id"]:"")."' name='form_dumpdata' method='post'>";
        print "<tr valign='top'><td>";
        print "<span class='boxtitle'>".LBL_LOAD_TABLE."</span><br><br> ";
        if (is_dir(GAME_DUMP_DIR)) {
            if ($h = opendir(GAME_DUMP_DIR)) {
                while (($file = readdir($h)) !== false ) {
                    if ($file<>"." && $file<>"..") {
                        print "<input type='radio' name='load_table' value='$file' > $file<br>";
                    }
                }
                closedir($h);
            }
        }
        print "</td></tr>";
        print "<tr><td><br>";
        print "<input type='submit' value = 'Load Table' class='textbox' name='submitload' style='border: 1px solid #000000'> ";
        print "<input type='submit' value = 'Cancel' class='textbox' name='submitload' style='border: 1px solid #000000'> ";
        print "</td></tr>";
        print "</form>";
        print "</table><br>";

    }

    function data_partition() {
        $rnd = rand(1,100);
        if ($rnd<=60) {
            return "R";
        } else {
            return "S";
        }
    }

    function inline_diff($text1, $text2, $nl) {

        // create the hacked lines for each file
        $htext1 = chunk_split($text1, 1, "\n");
        $htext2 = chunk_split($text2, 1, "\n");

        // convert the hacked texts to arrays
        // if you have PHP5, you can use str_split:
        /*
        $hlines1 = str_split(htext1, 2);
        $hlines2 = str_split(htext2, 2);
        */
        // otherwise, use this code
        for ($i=0;$i<strlen($text1);$i++) {
            $hlines1[$i] = substr($htext1, $i*2, 2);
        }
        for ($i=0;$i<strlen($text2);$i++) {
            $hlines2[$i] = substr($htext2, $i*2, 2);
        }

        /*
        $text1 = str_replace("\n",$nl,$text1);
        $text2 = str_replace("\n",$nl,$text2);
        */
        $text1 = str_replace("\n"," \n",$text1);
        $text2 = str_replace("\n"," \n",$text2);

        $hlines1 = explode(" ", $text1);
        $hlines2 = explode(" ", $text2);

        // create the diff object
        $diff = &new Text_Diff($hlines1, $hlines2);

        // get the diff in unified format
        // you can add 4 other parameters, which will be the ins/del prefix/suffix tags
        $renderer = &new Text_Diff_Renderer_inline(50000);
        return $renderer->render($diff);

    }

    function logentry() {
        if (func_num_args()>1) {
            $arg_list = func_get_args();
            $document_id = $arg_list[0]; // document id
            $inputstring = $arg_list[1]; // input string

            $sql = "select document_log from m_text_document where document_id = '$document_id'";
            if ($result = mysql_query($sql)) {
                if (mysql_num_rows($result)) {
                    if (list($logentry) = mysql_fetch_array($result)) {
                        $sql_update = "update m_text_document set document_log = '".$logentry."<br>".$inputstring."' ".
                                      "where document_id = '$document_id'";
                        mysql_query($sql_update);
                    }
                }
            }
        } else {
            print "SYNTAX: logentry(document_id String, inputString String) inputString: activity description";
        }
    }

    function display_rawtext() {
        if (func_num_args()) {
            $arg_list = func_get_args();
            $menu_id = $arg_list[0];
            $post_vars = $arg_list[1];
            $get_vars = $arg_list[2];
        }
        $sql = "select document_id, partition_status, raw_text, input1, input2 ".
               "from m_textlab_document ".
               "order by partition_status, document_id";
        if ($result = mysql_query($sql)) {
            if (mysql_num_rows($result)) {
                $i = 0;
                while (list($id, $partition, $raw_text, $input1, $input2) = mysql_fetch_array($result)) {
                    $i++;
                    $status = array(3);
                    $status[0] = ($input1?"1":"0");
                    $status[1] = ($input2?"2":"0");
                    $status[2] = ($raw_text?"3":"0");
                    print "<font color='#666600'>".str_pad($i, 3, "0", STR_PAD_LEFT)."</font> [".implode("",$status)."] <a href='".$_SERVER["SELF"]."?page=".$get_vars["page"]."&menu_id=$menu_id&document_id=$id&tab=CLEAN' class='ptmenu'>".
                          "<font color='".($partition=="R"?"red":"blue")."'>$id</font></a> <br>";
                }
            } else {
                print "<font color='red'>None</font>";
            }
        }
    }

    //
    // TRANSFORM SUBMODULE
    //

    function _transform () {
    //
    // Transform has several stages:
    // STAGE 1: abbreviation and symbol expansion / date correction
    // STAGE 2: spelling check
    // STAGE 3: final tagging
    // STAGE 4: noun phrases
    //
        if (func_num_args()>0) {
            $arg_list = func_get_args();
            $menu_id = $arg_list[0];
            $post_vars = $arg_list[1];
            $get_vars = $arg_list[2];
            $validuser = $arg_list[3];
            $isadmin = $arg_list[4];
            //print_r($arg_list);
        }
        // always check dependencies
        if ($exitinfo = $this->missing_dependencies('module')) {
            return print($exitinfo);
        }
        if ($exitinfo = $this->missing_dependencies('tagger')) {
            return print($exitinfo);
        }
        if ($exitinfo = $this->missing_dependencies('spelling')) {
            return print($exitinfo);
        }

        if ($post_vars["submittransform"]) {
            textlab::process_transform($menu_id,$post_vars,$get_vars);
        }
        if ($get_vars["document_id"]) {
            print "<table width='650' cellpadding='4' cellspacing='0'>";
            print "<tr valign='top'><td colspan='2'>";
            print "<span class='library'>".FTITLE_TRANSFORM_FORM."</span><br><br>";
            print "</td></tr>";
            print "<tr valign='top'><td bgcolor='#CCFFCC' colspan='2'>";
            textlab::transform_menu($menu_id, $post_vars, $get_vars);
            print "</td></tr>";
            print "<tr valign='top'><td bgcolor='#CCFFCC' nowrap width='20%'>";
            print textlab::list_records($menu_id, $post_vars, $get_vars);
            print "</td><td>";
            textlab::form_transform($menu_id,$post_vars,$get_vars);
            print "</td></tr>";
            print "</table>";
        } else {
            textlab::display_transform($menu_id,$post_vars,$get_vars);
        }
    }

    function transform_menu() {
        if (func_num_args()>0) {
            $arg_list = func_get_args();
            $menu_id = $arg_list[0];
            $post_vars = $arg_list[1];
            $get_vars = $arg_list[2];

            // default tab is CLEAN
            if (strlen($get_vars["tab"])==0) {
                $get_vars["tab"]="CLEAN";
            }

            // uncomment line below for debug
            //print_r($arg_list);

            print "<b>MENU</b> <a href='".$_SERVER[PHP_SELF]."?page=PROCESSING&menu_id=".$get_vars["menu_id"]."&document_id=".$get_vars["document_id"]."&tab=CLEAN' class='catmenu'>".($get_vars["tab"]=="CLEAN"?"<b><font color='#FF6600'>CLEAN</font></b>":"CLEAN")."</a>&nbsp;";
            print "<a href='".$_SERVER[PHP_SELF]."?page=PROCESSING&menu_id=".$get_vars["menu_id"]."&document_id=".$get_vars["document_id"]."&tab=SPELL' class='catmenu'>".($get_vars["tab"]=="SPELL"?"<b><font color='#FF6600'>SPELLING</font></b>":"SPELLING")."</a>&nbsp;";
            print "<a href='".$_SERVER[PHP_SELF]."?page=PROCESSING&menu_id=".$get_vars["menu_id"]."&document_id=".$get_vars["document_id"]."&tab=POS' class='catmenu'>".($get_vars["tab"]=="POS"?"<b><font color='#FF6600'>POS TAG</font></b>":"POS TAG")."</a>&nbsp;";
            print "<a href='".$_SERVER[PHP_SELF]."?page=PROCESSING&menu_id=".$get_vars["menu_id"]."&document_id=".$get_vars["document_id"]."&tab=CONCEPT' class='catmenu'>".($get_vars["tab"]=="CONCEPT"?"<b><font color='#FF6600'>CONCEPTS</font></b>":"CONCEPTS")."</a>&nbsp;";
            print "<a href='".$_SERVER[PHP_SELF]."?page=PROCESSING&menu_id=".$get_vars["menu_id"]."&document_id=".$get_vars["document_id"]."&tab=PHRASE' class='catmenu'>".($get_vars["tab"]=="PHRASE"?"<b><font color='#FF6600'>PHRASES</font></b>":"PHRASES")."</a>&nbsp;";
            print "<a href='".$_SERVER[PHP_SELF]."?page=PROCESSING&menu_id=".$get_vars["menu_id"]."&document_id=".$get_vars["document_id"]."&tab=NEGATION' class='catmenu'>".($get_vars["tab"]=="NEGATION"?"<b><font color='#FF6600'>NEGATION</font></b>":"NEGATION")."</a>&nbsp;";
            print "<a href='".$_SERVER[PHP_SELF]."?page=PROCESSING&menu_id=".$get_vars["menu_id"]."&document_id=".$get_vars["document_id"]."&tab=FILTER' class='catmenu'>".($get_vars["tab"]=="FILTER"?"<b><font color='#FF6600'>FILTER</font></b>":"FILTER")."</a>&nbsp;";
            print "<a href='".$_SERVER[PHP_SELF]."?page=PROCESSING&menu_id=".$get_vars["menu_id"]."&document_id=".$get_vars["document_id"]."&tab=SUMMARY' class='catmenu'>".($get_vars["tab"]=="SUMMARY"?"<b><font color='#FF6600'>SUMMARY</font></b>":"SUMMARY")."</a>&nbsp;";
        }
    }

    function list_records() {
        if (func_num_args()) {
            $arg_list = func_get_args();
            $menu_id = $arg_list[0];
            $post_vars = $arg_list[1];
            $get_vars = $arg_list[2];

            $sql = "select document_id, partition_status from m_textlab_document";
            if ($result = mysql_query($sql)) {
                if (mysql_num_rows($result)) {
                    while(list($document_id, $partition) = mysql_fetch_array($result)) {
                        $partition = ($partition=="R"?"<font color='red'>$partition</font>":"<font color='blue'>$partition</font>");
                        print "<a href='".$_SERVER[PHP_SELF]."?page=PROCESSING&menu_id=".$get_vars["menu_id"]."&document_id=".$document_id."&tab=CLEAN' class='catmenu'>".($get_vars["document_id"]==$document_id?"<b><font color='#006600'>$document_id</font></b>":$document_id)."</a>".$partition." <br>";
                    }
                }
            }
        }
    }

    function display_transform() {
        if (func_num_args()) {
            $arg_list = func_get_args();
            $menu_id = $arg_list[0];
            $post_vars = $arg_list[1];
            $get_vars = $arg_list[2];
        }
        print "<table width='600'>";
        print "<tr valign='top'><td colspan='3'>";
        print "<span class='library'>".FTITLE_RAWTEXT_LIST."</span><br>";
        print "</td></tr>";
        print "<tr valign='top'><td><b>".THEAD_DOCUMENT_ID."</b></td><td><b>".THEAD_PARTITION."</b></td><td><b>".THEAD_DOCUMENT_TEXT."</b></td></tr>";
        $sql = "select document_id, partition_status, raw_text from m_textlab_document order by document_id";
        if ($result = mysql_query($sql)) {
            if (mysql_num_rows($result)) {
                while (list($id, $partition, $rawtext) = mysql_fetch_array($result)) {
                    switch ($partition) {
                    case "R":
                        $partition_text = "TRAIN";
                        break;
                    case "S":
                        $partition_text = "TEST";
                    }
                    if ($partition=="R") {
                        print "<tr valign='top'><td><a href='".$_SERVER["SELF"]."?page=".$get_vars["page"]."&menu_id=$menu_id&document_id=$id&tab=CLEAN'>$id</a></td>";
                        print "<td>$partition_text</td>";
                        print "<td>".module::strfraction($rawtext,5)."</td></tr>";
                    }
                }
            } else {
                print "<tr colspan='3'><td><font color='red'>No raw text reports loaded.</font></td></tr>";
            }
        }
        print "</table><br>";
    }

    function document_info($textlab) {

        print "<table cellpadding='3' cellspacing='0'>";
        print "<tr valign='top'><td bgcolor='#CCCCFF'>DOCUMENT ID</td><td bgcolor='#FFFF99'>".$textlab["document_id"]."</td></tr>";
        print "<tr valign='top'><td bgcolor='#CCCCFF'>TOKEN COUNT</td><td bgcolor='#FFFF99'>".textlab::token_count($textlab["raw_text"])."</td></tr>";
        if ($textlab["postagged_text"]) {
            $sentences = count(preg_split("/(\._\.)|(\!_\.)|\?_\./", $textlab["postagged_text"]))-1;
            print "<tr valign='top'><td bgcolor='#CCCCFF'>SENTENCE COUNT</td><td bgcolor='#FFFF99'>$sentences</td></tr>";
        }
        if ($textlab["cuitagged_text"]) {
            $concept_count = umlstools::concept_count($textlab["cuitagged_text"]);
            print "<tr valign='top'><td bgcolor='#CCCCFF'>CONCEPT COUNT</td><td bgcolor='#FFFF99'>$concept_count</td></tr>";
        }
        if ($textlab["phrased_text"]) {
            $phrase_concept_count = textlab::phrase_concept_count($textlab["phrased_text"]);
            print "<tr valign='top'><td bgcolor='#CCCCFF'>CONCEPT COUNT WITH NOUN PHRASES</td><td bgcolor='#FFFF99'>".($concept_count+$phrase_concept_count)."</td></tr>";
        }
        print "<tr valign='top'><td bgcolor='#CCCCFF'>INVENTORY?</td><td bgcolor='#FFFF99'>".umlstools::inventory($textlab["document_id"])."</td></tr>";
        print "</table><br>";
    }

    function form_transform() {
        if (func_num_args()) {
            $arg_list = func_get_args();
            $menu_id = $arg_list[0];
            $post_vars = $arg_list[1];
            $get_vars = $arg_list[2];
            //print_r($arg_list);
            if ($get_vars["document_id"]) {
                $sql = "select document_id, province_code, raw_text, cleaned_text, spellchecked_text, ".
                       "postagged_text, cuitagged_text, phrased_text, cuitagged_text_predicted ".
                       "from m_textlab_document where document_id = '".$get_vars["document_id"]."'";
                if ($result = mysql_query($sql)) {
                    if (mysql_num_rows($result)) {
                        $textlab = mysql_fetch_array($result);
                        //print_r($textlab);
                    }
                }
            }
        }
        print "<table width='600'>";
        print "<form action = '".$_SERVER["SELF"]."?page=PROCESSING&menu_id=".$get_vars["menu_id"].($get_vars["document_id"]?"&document_id=".$get_vars["document_id"]:"").($get_vars["tab"]?"&tab=".$get_vars["tab"]:"")."' name='form_rawtext' method='post'>";
        print "<tr valign='top'><td>";
        print "<span class='boxtitle'>".LBL_DOCUMENT_DETAILS."</span><br> ";

        textlab::document_info($textlab);

        switch ($get_vars["tab"]) {

        case "SPELL":
            if (strlen(trim($textlab["cleaned_text"]))>0) {
                print "<tr><td>";
                print "<span class='boxtitle'>".LBL_CLEANED_TEXT."</span><br> ";

                print "<table width='100%' cellpadding='3' cellspacing='0'>";
                print "<tr valign='top'><td bgcolor='#99CC66'>";
                print spelling::mark_text($get_vars, $textlab["cleaned_text"])."<br><br>";
                print "</td><td bgcolor='#CCFF99' width='20%'>";
                print spelling::misspelled_list($get_vars, $textlab["cleaned_text"]);
                print "</td></tr>";
                print "</table>";

                print "</td></tr>";
                if ($post_vars["spellcheck"] || $get_vars["spellcheck"] || $post_vars["submitdict"]) {
                    print "<tr><td>";
                    spelling::manage_term($menu_id, $get_vars, $post_vars, $textlab);
                    print "</td></tr>";
                } else {
                    print "<tr><td>";

                    print "<table width='100%' cellpadding='3' cellspacing='0'>";
                    print "<tr valign='top'><td bgcolor='#99CCCC'>";
                    print "<span class='boxtitle'>".LBL_SPELLCHECKED_TEXT."</span><br> ";
                    if ($textlab["spellchecked_text"]) {
                        print spelling::mark_text($get_vars, $textlab["spellchecked_text"])."<br><br>";
                    } else {
                        print "<font color='red'>No spell-checked text.</font>";
                    }
                    print "</td><td bgcolor='#CCFFCC' width='20%'>";
                    print spelling::misspelled_list($get_vars, $textlab["spellchecked_text"]);
                    print "</td></tr>";
                    print "</table>";

                    print "</td></tr>";

                }
                print "<tr><td>";
                print "<span class='boxtitle'>".LBL_DIFF_TEXT."</span><br> ";
                if ($textlab["cleaned_text"] && $textlab["spellchecked_text"]) {
                    print "<span class='tinylight'><i>IMPORTANT: This compares database entries for cleaned text and spell-checked text.</i></span><br><br>";
                    $text1=trim($textlab["cleaned_text"]);
                    $text2=trim($textlab["spellchecked_text"]);
                    $nl = '#**!)@#';
                    $diff = textlab::inline_diff($text1, $text2, $nl);
                    print '<style>del{background:#fcc}ins{background:#cfc}</style>'.$diff."\n";
                } else {
                    print "<font color='red'>Cleaned text has not been saved.</font>";
                }
                if ($get_vars["document_id"] or $textlab["document_id"]) {
                    print "</td></tr>";
                    print "<tr><td><br>";
                    print "<input type='hidden' name='raw_text' value='".$textlab["raw_text"]."'>";
                    print "<input type='hidden' name='cleaned_text' value='".$textlab["cleaned_text"]."'>";
                    print "<input type='hidden' name='spellchecked_text' value='".$textlab["spellchecked_text"]."'>";
                    print "<input type='hidden' name='document_id' value='".($get_vars["document_id"]?$get_vars["document_id"]:$textlab["document_id"])."'>";
                    print "<input type='submit' value = 'Update Spelling' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "<input type='submit' value = 'Clear Corrections' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "<input type='submit' value = 'Cancel' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "</td></tr>";
                }
            } else {
                print "<font color='red'>No cleaned text to process.</font>";
            }
            break;

        case "POS":
            if (strlen(trim($textlab["spellchecked_text"]))>0) {

                print "<tr><td>";
                print "<span class='boxtitle'>".LBL_SPELLCHECKED_TEXT."</span><br> ";
                print stripslashes($textlab["spellchecked_text"])."<br><br>";
                print "</td></tr>";
                print "<tr><td>";
                print "<span class='boxtitle'>".LBL_TAGGED_TEXT."</span><br> ";
                    if (strlen(trim($textlab["postagged_text"]))>0) {
                        print stripslashes($textlab["postagged_text"])."<br><br>";
                    } else {
                        print "<font color='red'>None</font>";
                    }
                print "</td></tr>";
                print "<tr><td><br>";
                if ($get_vars["document_id"] or $textlab["document_id"]) {
                    print "<input type='hidden' name='spellchecked_text' value='".$textlab["spellchecked_text"]."'>";
                    print "<input type='hidden' name='tagged_text' value='".$textlab["postagged_text"]."'>";
                    print "<input type='hidden' name='document_id' value='".($get_vars["document_id"]?$get_vars["document_id"]:$textlab["document_id"])."'>";
                    print "<input type='submit' value = 'Tag Document' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "<input type='submit' value = 'Clear POS Tags' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "<input type='submit' value = 'Cancel' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                }
                print "</td></tr>";
            } else {
                print "<font color='red'>No spell-checked text to process.</font>";
            }
            break;

        case "CONCEPT":
            if (strlen(trim($textlab["spellchecked_text"]))>0 && strlen(trim($textlab["postagged_text"]))>0) {

                print "<tr><td>";
                print "<span class='boxtitle'>".LBL_TAGGED_TEXT."</span><br> ";
                print stripslashes($textlab["postagged_text"])."<br><br>";
                print "</td></tr>";
                print "<tr><td>";

                if ($get_vars["cuitagged"] || $post_vars["submitcui"]=="Adopt Configuration" || $post_vars["submitcui"]=="Next") {
                    umlstools::cui_manager($menu_id, $post_vars, $get_vars, $textlab);
                } else {
                    print "<table width='100%' cellpadding='1' cellspacing='0'>";
                    print "<tr valign='top'><td>";
                    print "<span class='boxtitle'>".LBL_CUITAGGED_TEXT."</span><br>";
                    if ($textlab["cuitagged_text"]) {
                        // show concept tagged text highlighted
                        print stripslashes(umlstools::tag_highlight($menu_id, $post_vars, $get_vars, $textlab["cuitagged_text"], "actual"))."<br>";
                    } else {
                        print "<font color='red'>None</font>";
                    }
                }
                print "</td><td nowrap>";
                print umlstools::concept_list($menu_id, $post_vars, $get_vars);
                print "</td></tr>";
                print "</table>";

                print "</td></tr>";
                print "<tr><td><br>";
                if (($get_vars["document_id"] or $textlab["document_id"]) && !$get_vars["cuitagged"]) {
                    print "<input type='hidden' name='cleaned_text' value='".$textlab["spellchecked_text"]."'>";
                    print "<input type='hidden' name='tagged_text' value='".$textlab["postagged_text"]."'>";
                    print "<input type='hidden' name='document_id' value='".($get_vars["document_id"]?$get_vars["document_id"]:$textlab["document_id"])."'>";
                    print "<input type='submit' value = 'Concept Tag' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "<input type='submit' value = 'Clear Concept Tags' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "<input type='submit' value = 'Cancel' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                }

                print "</td></tr>";
            }
            break;

        case "PHRASE":
            if (strlen(trim($textlab["spellchecked_text"]))>0 && strlen(trim($textlab["postagged_text"]))>0) {
                print "<tr><td>";

                if ($get_vars["cuitagged"] || $post_vars["submitcui"]=="Adopt Configuration" || $post_vars["submitcui"]=="Next") {
                    umlstools::cui_manager($menu_id, $post_vars, $get_vars, $textlab);
                } else {
                    print "<table width='100%' cellpadding='1' cellspacing='0'>";
                    print "<tr valign='top'><td>";
                    print "<span class='boxtitle'>".LBL_CUITAGGED_TEXT."</span><br>";
                    if ($textlab["cuitagged_text"]) {
                        // show concept tagged text highlighted
                        print stripslashes(umlstools::tag_highlight($menu_id, $post_vars, $get_vars, $textlab["cuitagged_text"], "actual"))."<br>";
                        print "<br><span class='boxtitle'>".LBL_NOUN_PHRASES."</span><br><br>";
                        if (strlen(trim($textlab["phrased_text"]))>0) {
                            print nl2br(umlstools::nounphrase_format($menu_id, $post_vars, $get_vars, $textlab["phrased_text"]));
                        } else {
                            print "<font color='red'>None</font>";
                        }
                } else {
                    print "<font color='red'>None</font>";
                }
                print "<br>";
                print "<span class='boxtitle'>".LBL_CUITAGGED_TEXT_PREDICTED."</span><br>";
                if ($textlab["cuitagged_text_predicted"]) {
                    // show concept tagged text highlighted
                    print stripslashes(umlstools::tag_highlight($menu_id, $post_vars, $get_vars, $textlab["cuitagged_text_predicted"], "predicted"))."<br><br>";
                    print "<span class='boxtitle'>".LBL_DIFF_TEXT."</span><br> ";
                    if ($textlab["cuitagged_text"] && $textlab["cuitagged_text_predicted"]) {
                        print "<span class='tinylight'><i>IMPORTANT: This compares database entries for concept tagging with and without semantic distance determination. </i></span><br><br>";
                        $text1=trim($textlab["cuitagged_text"]);
                        $text2=trim($textlab["cuitagged_text_predicted"]);
                        $nl = '#**!)@#';
                        $diff = textlab::inline_diff($text1, $text2, $nl);
                        print '<style>del{background:#fcc}ins{background:#cfc}</style>'.$diff."\n";
                    }
                } else {
                    print "<font color='red'>No CUI-tagged predicted text detected</font>";
                }
                print "</td><td>";
                print umlstools::concept_list($menu_id, $post_vars, $get_vars, $textlab["cuitagged_text"], $textlab["phrased_text"]);
                print "</td></tr>";
                print "</table>";
                }

                print "</td></tr>";
                if ($get_vars["document_id"] or $textlab["document_id"]) {
                    print "<tr><td><br>";
                    print "<input type='hidden' name='cuitagged_text' value='".$textlab["cuitagged_text"]."'>";
                    print "<input type='hidden' name='postagged_text' value='".$textlab["postagged_text"]."'>";
                    print "<input type='hidden' name='phrased_text' value='".$textlab["phrased_text"]."'>";
                    print "<input type='hidden' name='document_id' value='".($get_vars["document_id"]?$get_vars["document_id"]:$textlab["document_id"])."'>";
                    print "<input type='submit' value = 'Detect Noun Phrases' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "<input type='submit' value = 'Clear Noun Phrases' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "<input type='submit' value = 'Predict Tags' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "</td></tr>";
                    print "<tr><td>";
                    print "<input type='submit' value = 'Update Concept Inventory' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "<input type='submit' value = 'Cancel' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "</td></tr>";
                }

            }
            break;

        case "NEGATION":
            if (strlen(trim($textlab["spellchecked_text"]))>0 && strlen(trim($textlab["postagged_text"]))>0) {
                print "<tr><td>";

                print "<table width='100%' cellpadding='1' cellspacing='0'>";
                print "<tr valign='top'><td>";
                print "<span class='boxtitle'>".LBL_CUITAGGED_TEXT."</span><br>";
                if ($textlab["cuitagged_text"]) {
                    // show concept tagged text highlighted
                    print stripslashes(umlstools::tag_highlight($menu_id, $post_vars, $get_vars, $textlab["cuitagged_text"], "actual"))."<br>";
                    if ($get_vars["cuitagged"]) {
                        print umlstools::cui_details($get_vars["cuitagged"])."<br>";
                    }
                    print "<br><span class='boxtitle'>".LBL_NOUN_PHRASES."</span><br><br>";
                    if (strlen(trim($textlab["phrased_text"]))>0) {
                        print nl2br(umlstools::nounphrase_format($menu_id, $post_vars, $get_vars, $textlab["phrased_text"]));
                        print "<br>";
                    } else {
                        print "<font color='red'>None</font>";
                    }
                    print "<br><span class='boxtitle'>".LBL_NEGATED_CONCEPTS."</span><br><br>";
                    print nl2br(negtracker::negated_concepts($textlab["cuitagged_text"]));
                } else {
                    print "<font color='red'>None</font>";
                }
                print "</td><td>";
                print umlstools::concept_list($menu_id, $post_vars, $get_vars, $textlab["cuitagged_text"], $textlab["phrased_text"]);
                print "</td></tr>";
                print "</table>";

                print "</td></tr>";
                print "<tr><td><br>";
                if ($get_vars["document_id"] or $textlab["document_id"]) {
                    print "<input type='hidden' name='cuitagged_text' value='".$textlab["cuitagged_text"]."'>";
                    print "<input type='hidden' name='phrased_text' value='".$textlab["phrased_text"]."'>";
                    print "<input type='hidden' name='document_id' value='".($get_vars["document_id"]?$get_vars["document_id"]:$textlab["document_id"])."'>";
                    print "<input type='submit' value = 'Detect Noun Phrases' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "<input type='submit' value = 'Clear Noun Phrases' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "<input type='submit' value = 'Cancel' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                }

                print "</td></tr>";
            }
            break;

        case "FILTER":
            if (strlen(trim($textlab["cuitagged_text"]))>0) {
                print "<tr><td>";

                print "<table width='100%' cellpadding='1' cellspacing='0'>";
                print "<tr valign='top'><td>";

                if ($get_vars["cuitagged"] || $post_vars["submitcui"]=="Adopt Configuration" || $post_vars["submitcui"]=="Next") {
                    umlstools::cui_manager($menu_id, $post_vars, $get_vars, $textlab);
                } else {
                    print "<span class='boxtitle'>".LBL_CUITAGGED_TEXT."</span><br>";
                    if ($textlab["cuitagged_text"]) {
                        // show concept tagged text highlighted
                        print stripslashes(umlstools::tag_highlight($menu_id, $post_vars, $get_vars, $textlab["cuitagged_text"], "actual"))."<br>";
                        print "<br><span class='boxtitle'>".LBL_NOUN_PHRASES."</span><br><br>";
                        if (strlen(trim($textlab["phrased_text"]))>0) {
                            print nl2br(umlstools::nounphrase_format($menu_id, $post_vars, $get_vars, $textlab["phrased_text"]));
                            print "<br>";
                        } else {
                            print "<font color='red'>None</font>";
                        }
                        print "<br><span class='boxtitle'>".LBL_NEGATED_CONCEPTS."</span><br><br>";
                        print nl2br(negtracker::negated_concepts($textlab["cuitagged_text"]))."<br>";
                        print "<br><span class='boxtitle'>".LBL_FILTERED_TEXT."</span><br><br>";
                        $filtered_text = umlstools::filter($textlab["cuitagged_text"]);
                        print $filtered_text;
                    } else {
                        print "<font color='red'>None</font>";
                    }
                }

                print "</td><td>";
                print umlstools::concept_list($menu_id, $post_vars, $get_vars, $textlab["cuitagged_text"], $textlab["phrased_text"]);
                print "</td></tr>";
                print "</table>";

                print "</td></tr>";
                if (($get_vars["document_id"] or $textlab["document_id"]) && !$get_vars["cuitagged"]) {
                    print "<tr><td><br>";
                    print "<input type='hidden' name='cuitagged_text' value='".$textlab["cuitagged_text"]."'>";
                    print "<input type='hidden' name='phrased_text' value='".$textlab["phrased_text"]."'>";
                    print "<input type='hidden' name='filtered_text' value='".$filtered_text."'>";
                    print "<input type='hidden' name='document_id' value='".($get_vars["document_id"]?$get_vars["document_id"]:$textlab["document_id"])."'>";
                    print "<input type='submit' value = 'Save Filtered Text' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "<input type='submit' value = 'Clear Filtered Text' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "</td></tr>";
                    print "<tr><td>";
                    print "<input type='submit' value = 'Cancel' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "</td></tr>";
                }

            }
            break;

        case "SUMMARY":
            if (strlen(trim($textlab["cuitagged_text"]))>0) {
                print "<tr><td>";

                print "<table cellpadding='4' cellspacing='0'>";
                print "<tr><td>";
                print "<span class='boxtitle'>".LBL_DOCUMENT_ENTROPY."</span>";
                visualize::show_entropy($get_vars["document_id"]);
                print "<td></tr>";
                print "<tr><td>";
                print "<span class='boxtitle'>".LBL_DOCUMENT_GRAPHS."</span>";
                $STY_data = visualize::get_frequencies($get_vars["document_id"], "STY");
                visualize::write_graph($get_vars["document_id"], "HBAR1", "STY", "Semantic Type Frequencies", $STY_data, 600, 600);
                print "<td></tr>";
                print "<tr><td>";
                $TAG_data = visualize::get_frequencies($get_vars["document_id"], "TAG");
                visualize::write_graph($get_vars["document_id"], "HBAR1", "TAG", "Part-of-speech Tag Frequencies", $TAG_data, 600,600);
                print "</td></tr>";
                print "<tr><td>";
                $TAG2_data = visualize::get_frequencies($get_vars["document_id"], "TAG2");
                visualize::write_graph($get_vars["document_id"], "HBAR2", "TAG", "Part-of-speech Tag Frequencies and Concepts", $TAG2_data, 600,700);
                print "</td></tr>";
                print "<tr><td>";
                $TAG_data = visualize::get_frequencies($get_vars["document_id"], "CONCEPT");
                visualize::write_graph($get_vars["document_id"], "HBAR1", "CONCEPT", "UMLS Concept Frequencies", $TAG_data, 600,850);
                print "</td></tr>";
                print "</table>";

                print "</td></tr>";
                print "</td></tr>";
            }
            break;

        case "CLEAN":
            if (strlen(trim($textlab["raw_text"]))>0) {
                print "<tr valign='top'><td>";
                print "<span class='boxtitle'>".LBL_RAWTEXT."</span><br> ";
                print ($textlab["raw_text"]?stripslashes($textlab["raw_text"]):"");
                print "</td></tr>";
                print "<tr><td>";
                print "<a name='spellcheck'>";
                print "<span class='boxtitle'>".LBL_CLEANED_TEXT."</span><br> ";
                $time_start = textlab::timer("start");
                $cleaned_text = umlstools::scrubber($textlab["raw_text"]);
                print $cleaned_text;
                $elapsed = textlab::timer("stop") -$time_start;
                print $elapsed;
                print "<br><br>";
                print "</td></tr>";
                print "<tr><td>";
                print "<span class='boxtitle'>".LBL_DIFF_TEXT."</span><br> ";
                if ($textlab["cleaned_text"]) {
                    print "<span class='tinylight'><i>IMPORTANT: This compares database entries for raw text and cleaned text.</i></span><br><br>";
                    $text1=$textlab["raw_text"];
                    $text2=$textlab["cleaned_text"];
                    $nl = '#**!)@#';
                    $diff = textlab::inline_diff($text1, $text2, $nl);
                    print '<style>del{background:#fcc}ins{background:#cfc}</style>'.$diff."\n";
                } else {
                    print "<font color='red'>Cleaned text has not been saved.</font>";
                }

                print "</td></tr>";
                print "<tr><td><br>";
                if ($get_vars["document_id"] or $textlab["document_id"]) {
                    print "<input type='hidden' name='raw_text' value='".$textlab["raw_text"]."'>";
                    print "<input type='hidden' name='cleaned_text' value='$cleaned_text'>";
                    print "<input type='hidden' name='document_id' value='".($get_vars["document_id"]?$get_vars["document_id"]:$textlab["document_id"])."'>";
                    print "<input type='submit' value = 'Save Replacements' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "<input type='submit' value = 'Clear Replacements' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                    print "<input type='submit' value = 'Cancel' class='textbox' name='submittransform' style='border: 1px solid #000000'> ";
                }
                print "</td></tr>";
            }
        }

        print "</td></tr>";
        print "</form>";
        print "</table><br>";
    }

    function process_transform() {
        if (func_num_args()) {
            $arg_list = func_get_args();
            $menu_id = $arg_list[0];
            $post_vars = $arg_list[1];
            $get_vars = $arg_list[2];
            //print_r($arg_list);
        }
        switch($post_vars["submittransform"]) {
        case "Cancel":
            header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&tab=".$get_vars["tab"]);
            break;

        // REPLACEMENTS
        case "Save Replacements":
            if ($post_vars["document_id"] && $post_vars["raw_text"]) {
                $sql = "update m_textlab_document set ".
                       "cleaned_text = \"".$post_vars["cleaned_text"]."\" ".
                       "where document_id = '".$post_vars["document_id"]."'";
                if ($result = mysql_query($sql) or die(mysql_errno().": ".mysql_error())) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$post_vars["document_id"]."&tab=".$get_vars["tab"]);
                }
            }
            break;
        case "Clear Replacements":
            if ($post_vars["document_id"] && $post_vars["cleaned_text"]) {
                $sql = "update m_textlab_document set ".
                       "cleaned_text = '' ".
                       "where document_id = '".$post_vars["document_id"]."'";
                if ($result = mysql_query($sql) or die(mysql_errno().": ".mysql_error())) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$post_vars["document_id"]."&tab=".$get_vars["tab"]);
                }
            }
            break;

        // SPELLING
        case "Clear Corrections":
            if ($post_vars["document_id"] && $post_vars["spellchecked_text"]) {
                $sql = "update m_textlab_document set ".
                       "spellchecked_text = '' ".
                       "where document_id = '".$post_vars["document_id"]."'";
                if ($result = mysql_query($sql) or die(mysql_errno().": ".mysql_error())) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$post_vars["document_id"]."&tab=".$get_vars["tab"]);
                }
            }
            break;
        case "Update Spelling":
            if ($post_vars["document_id"] && $post_vars["cleaned_text"]) {
                $sql = "update m_textlab_document set ".
                       "spellchecked_text = '".$post_vars["cleaned_text"]."' ".
                       "where document_id = '".$post_vars["document_id"]."'";
                if ($result = mysql_query($sql) or die(mysql_errno().": ".mysql_error())) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$post_vars["document_id"]."&tab=".$get_vars["tab"]);
                }
            }
            break;

        // FILTERED TEXT
        case "Save Filtered Text";
            if ($post_vars["document_id"] && $post_vars["filtered_text"]) {
                $sql = "update m_textlab_document set ".
                       "filtered_text = \"".$post_vars["filtered_text"]."\" ".
                       "where document_id = '".$post_vars["document_id"]."'";
                if ($result = mysql_query($sql) or die(mysql_errno().": ".mysql_error())) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$post_vars["document_id"]."&tab=".$get_vars["tab"]);
                }
            }
            break;

        case "Clear Filtered Text";
            if ($post_vars["document_id"] && $post_vars["filtered_text"]) {
                $sql = "update m_textlab_document set ".
                       "filtered_text = '' ".
                       "where document_id = '".$post_vars["document_id"]."'";
                if ($result = mysql_query($sql) or die(mysql_errno().": ".mysql_error())) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$post_vars["document_id"]."&tab=".$get_vars["tab"]);
                }
            }
            break;

        case "Update Concept Inventory";
            if ($post_vars["document_id"] && $post_vars["cuitagged_text"]) {
                umlstools::term_inventory($post_vars["cuitagged_text"], $post_vars["document_id"]);
                // run bigram inventory update since m_textlab_terms will have been updated
                umlstools::bigram_inventory();
                //header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$post_vars["document_id"]."&tab=".$get_vars["tab"]);
            }
            break;

        // CONCEPT TAGGING
        case "Concept Tag":
            if ($post_vars["document_id"] && $post_vars["tagged_text"]) {
                $concepttext = umlstools::concept_tag($post_vars["tagged_text"]);
                $sql = "update m_textlab_document set ".
                       "cuitagged_text = \"".addslashes($concepttext)."\" ".
                       "where document_id = '".$post_vars["document_id"]."'";
                if ($result = mysql_query($sql) or die(mysql_errno().": ".mysql_error())) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$post_vars["document_id"]."&tab=".$get_vars["tab"]);
                }
            }
            break;
        case "Clear Concept Tags":
            if ($post_vars["document_id"] && $post_vars["tagged_text"]) {
                $sql = "update m_textlab_document set ".
                       "cuitagged_text = '' ".
                       "where document_id = '".$post_vars["document_id"]."'";
                if ($result = mysql_query($sql) or die(mysql_errno().": ".mysql_error())) {
                    $sql_delete = "delete from m_textlab_terms where document_id = '".$post_vars["document_id"]."'";
                    $result_delete = mysql_query($sql_delete);
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$post_vars["document_id"]."&tab=".$get_vars["tab"]);
                }
            }
            break;

        // POS TAGGING
        case "Tag Document":
            if ($post_vars["document_id"] && $post_vars["spellchecked_text"]) {
                $taggedtext = tagger::tagtext($post_vars["spellchecked_text"], "text");
                $sql = "update m_textlab_document set ".
                       "postagged_text = '".addslashes($taggedtext)."' ".
                       "where document_id = '".$post_vars["document_id"]."'";
                if ($result = mysql_query($sql) or die(mysql_errno().": ".mysql_error())) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$post_vars["document_id"]."&tab=".$get_vars["tab"]);
                }
            }
            break;

        case "Clear POS Tags":
            if ($post_vars["document_id"] && $post_vars["tagged_text"]) {
                $sql = "update m_textlab_document set ".
                       "postagged_text = '' ".
                       "where document_id = '".$post_vars["document_id"]."'";
                if ($result = mysql_query($sql) or die(mysql_errno().": ".mysql_error())) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$post_vars["document_id"]."&tab=".$get_vars["tab"]);
                }
            }
            break;

        // NOUN PHRASE DETECTION
        case "Detect Noun Phrases":
            if ($post_vars["document_id"] && $post_vars["cuitagged_text"]) {
                $detected_phrases = umlstools::phrase_detect($post_vars["cuitagged_text"]);
                $sql = "update m_textlab_document set ".
                       "phrased_text = '".addslashes($detected_phrases)."' ".
                       "where document_id = '".$post_vars["document_id"]."'";
                if ($result = mysql_query($sql) or die(mysql_errno().": ".mysql_error())) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$post_vars["document_id"]."&tab=".$get_vars["tab"]);
                }
            }
            break;

        case "Clear Noun Phrases":
            if ($post_vars["document_id"] && $post_vars["phrased_text"]) {
                print $sql = "update m_textlab_document set ".
                       "phrased_text = '' ".
                       "where document_id = '".$post_vars["document_id"]."'";
                if ($result = mysql_query($sql) or die(mysql_errno().": ".mysql_error())) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$post_vars["document_id"]."&tab=".$get_vars["tab"]);
                }
            }
            break;

        case "Predict Tags":
            if ($post_vars["document_id"] && $post_vars["postagged_text"]) {
                $predicted = umlstools::predict_concept_tags($post_vars["postagged_text"]);
                $sql = "update m_textlab_document set ".
                       "cuitagged_text_predicted = '".$predicted."' ".
                       "where document_id = '".$post_vars["document_id"]."'";
                if ($result = mysql_query($sql) or die(mysql_errno().": ".mysql_error())) {
                    header("location: ".$_SERVER["PHP_SELF"]."?page=".$get_vars["page"]."&menu_id=".$get_vars["menu_id"]."&document_id=".$post_vars["document_id"]."&tab=".$get_vars["tab"]);
                }
            }

        }
    }

    function token_count() {
        if (func_num_args()) {
            $arg_list = func_get_args();
            $raw_text = $arg_list[0];
            return count(explode(" ", $raw_text));
        }
    }

    function phrase_concept_count() {
        if (func_num_args()) {
            $arg_list = func_get_args();
            $inputstring = $arg_list[0];

            return count(explode(" ", $inputstring));
        }
    }

    function timer($interval) {

        static $timestart, $timestop, $elapsed;

        switch($interval) {
        case "start":
            $timestart = time();
            $format = "%01.4f";
            return sprintf($format, $timestart);
            break;
        case "stop":
            $timestop = time();
            $format = "%01.4f";
            return sprintf($format, $timestop);
            break;
        case "elapsed":
            $format = "%01.4f";
            $elapsed = $timestop-$timestart;
            return sprintf($format, $elapsed);
            break;
        }
    }


// end of class
}
?>
