<?
class ontomap extends module {

    //
    // Author: Herman Tolentino (unless specified)
    //
    // AEFI NLP Project
    // Vaccine Analytic Unit - Brighton Collaboration - National Library of Medicine
    //
    // IMPORTANT:
    // This assumes that the RAP is installed in the home directory of this application and is
    // defined in the constant RDFAPI_INCLUDE_DIR in index.php. RAP was created by Chris Bizer.
    //

    function ontomap() {
        //
        // do not forget to update version
        //
        $this->author = 'Herman Tolentino MD';
        $this->version = "0.1-".date("Y-m-d");
        $this->module = "ontomap";
        $this->description = "AEFI Module - Ontology Class";
        // 0.1: BEGIN

        $this->ontology_home = '';

    }

    function init_deps() {
    //
    // insert dependencies in module_dependencies
    //
        module::set_dep($this->module, "module");

    }

    function init_lang() {
    //
    // insert necessary language directives
    //
    }

    function init_menu() {
        if (func_num_args()>0) {
            $arg_list = func_get_args();
            $module_id = $arg_list[0];
        }

        module::set_menu($this->module, "Manage Ontology", "ONTOLOGY", "_build_ont");
        module::set_menu($this->module, "Query Ontology", "ONTOLOGY", "_query_ont");

        // put in more details
        module::set_detail($this->description, $this->version, $this->author, $this->module);
    }

    function init_stats() {
    }

    function init_help() {
    }

    function init_sql() {
    //
    // use RAP table generation
    //
        $rdf_database = new DbStore('MySQL', 'localhost', 'game', 'root', '' );
        $rdf_database->createTables('MySQL');
    }

    function drop_tables() {

        module::execsql("DROP TABLE `statements`;");
        module::execsql("DROP TABLE `namespaces`;");
        module::execsql("DROP TABLE `models`;");
        module::execsql("DROP TABLE `datasets`;");
        module::execsql("DROP TABLE `dataset_model`;");

    }


    // --------------- CUSTOM MODULE FUNCTIONS ------------------

    function set_ontology_home($base_uri) {
        if ($base_uri) {
            $this->ontology_home = $base_uri;
            return true;
        }
    }

    function _query_ont() {

        $base = './game/ont/aefi.rdf';
        $n3file = './game/ont/aefi.n3';
        $o = new ontology();
        $o->set_base($base);
        $triples = $o->get_triples();
        $graph = new graphviz($triples);
        $graph->filename("aefi.dot");
        $graph->write_dot();
        $graph->draw();
    }

    function form_query_ont() {
    }

    function display_query_ont() {
    }

    function process_query_ont() {
    }

}

class aefi {

    function aefi() {
    }

    function encounter() {
    }

    function vaccine() {
    }

    function ssx() {
    }
}

class ontology {

    var $base_uri;
    var $array_summary;
    var $model;
    var $encounter;

    function ontology () {
        $this->encounter = array();
        $this->model = new MemModel();
    }

    function n3toRDF($n3file) {
        $f = fopen($n3file, "r");
        while (!feof($f)) {
            $contents .= fread($f, 8192);
        }
        print $contents;
    }

    function set_base($base_uri) {
        $this->base_uri = $base_uri;
        $this->model->load($this->base_uri);
    }

    function get_stype($searchtype) {

        $query = "SELECT ?resource, ?value ".
                 "WHERE ".
                 "(?resource aefi:has_STYPE ?value) ".
                 "USING aefi FOR <http://www.owl-ontologies.com/unnamed.owl#> ";
        $res = $this->model->rdqlQuery($query);
        foreach ($res as $key=>$value) {
            if ($searchtype == $res[$key]["?value"]->label) {
                list($url, $resource) = explode("#", $res[$key]["?resource"]->uri);
                return $resource;
            }
        }
    }

    function get_concept($searchconcept) {
        $query = "SELECT ?resource, ?value ".
                 "WHERE ".
                 "(?resource, aefi:has_CUI, ?value) ".
                 "USING aefi FOR <http://www.owl-ontologies.com/unnamed.owl#> ";
        $res = $this->model->rdqlQuery($query);
    }

    function get_triples() {
        $query = "SELECT ?x, ?y, ?z ".
                 "WHERE ".
                 "(?x, ?y, ?z) ".
                 "USING aefi FOR <http://www.owl-ontologies.com/unnamed.owl#> ".
                 "xsd FOR <http://www.w3.org/2001/XMLSchema#> ".
                 "rdfs FOR <http://www.w3.org/2000/01/rdf-schema#> ".
                 "rdf FOR <http://www.w3.org/1999/02/22-rdf-syntax-ns#> ".
                 "owl FOR <http://www.w3.org/2002/07/owl#>";
        $res = $this->model->rdqlQuery($query);
        foreach ($res as $key=>$value) {
            list($url, $subject) = explode("#", $res[$key]["?x"]->uri);
            if (!$subject) {
                $parts = explode("/", $res[$key]["?x"]->uri);
                $count = count($parts);
                $subject = $parts[$count-1];
                $subject = preg_replace("/([.])/", "_", $subject);
                $graph_title = $subject;
            }
            list($url, $predicate) = explode("#", $res[$key]["?y"]->uri);
            list($url, $object) = explode("#", $res[$key]["?z"]->uri);
            $literal = $res[$key]["?z"]->label;
            $object = ($object?$object:$literal);
            $dot_array[] = "$subject||$predicate||$object";
        }
        return $dot_array;
    }

}

class graphviz {

    var $triples;
    var $filename;

    function graphviz($triples) {
        $this->triples = $triples;
    }

    function filename($file) {
        $this->filename = $file;
    }

    function write_dot() {

        $dot .= "digraph unix {\n".
                "\trankdir=LR \n".
                "\tsize=\"50,50\" \n".
                "\tcenter=\"\" \n".
                "\tnode [color=lightblue2, style=filled] \n";
        for ($i=0; $i < count($this->triples); $i++) {
            list($subject, $predicate, $object) = explode("||", $this->triples[$i]) ;
            $dot .= "\t\"$subject\" -> \"$object\" [ label = \"$predicate\"];\n";
        }
        $dot .= "}";
        //print nl2br($dot);
        $filename = getcwd()."/".GAME_GRAPH_DIR."/".$this->filename;
        $f = fopen($filename,"w+");
        if (fwrite($f, $dot)) {
            fclose($f);
        }
        $this->process($filename);
    }

    function process($file) {

        $commandstring = GRAPHVIZ_DIR."/dot -Tpng $file -o ".$file.".png";
        // The following is a backtick operator.
        // Graphviz 'dot' apparently does not work with any
        // other shell execution commands.
        `$commandstring`;
    }

    function draw() {

        print "<img src='./".GAME_GRAPH_DIR."/".$this->filename.".png'>";
    }
}
?>
