<?
class negtracker extends module {

    //
    // Author: Herman Tolentino (unless specified)
    // ngram method author: Mikko Saari
    // ngram source url: http://www.melankolia.net/archives/2004/11/ngram_string_ma.html
    //
    // AEFI NLP Project
    // Vaccine Analytic Unit - Brighton Collaboration - National Library of Medicine
    //
    // IMPORTANT:
    // This assumes that the UMLS Lexicon tables have been set up and that the LRAGR table
    // has been indexed using STR.
    //

    function negtracker() {
        //
        // do not forget to update version
        //
        $this->author = 'Herman Tolentino MD';
        $this->version = "0.1-".date("Y-m-d");
        $this->module = "negtracker";
        $this->description = "AEFI Module - Negation Tracker";
        // 0.1: BEGIN

    }

    function init_deps() {
    //
    // insert dependencies in module_dependencies
    //
        module::set_dep($this->module, "module");

    }

    function init_lang() {
    //
    // insert necessary language directives
    //
        module::set_lang("FTITLE_SPELLING_CHECK", "english", "SPELLING CHECK", "Y");
        module::set_lang("INSTR_SPELLING_CHECK", "english", "CLICK ON THE HIGHLIGHTED TERMS ABOVE", "Y");
        module::set_lang("LBL_POSSIBLE_MISPELLED", "english", "POSSIBLE MISPELLED WORD", "Y");
        module::set_lang("LBL_POSSIBLE_CORRECTIONS", "english", "POSSIBLE CORRECTIONS", "Y");
        module::set_lang("LBL_REPLACEMENT_TERM", "english", "REPLACEMENT TERM", "Y");
        module::set_lang("INSTR_SPELLCORRECTION_LIST", "english", "PICK ONE FROM THE LIST AND CLICK ON <b>Replace from Correction List</b>", "Y");
        module::set_lang("LBL_SPELLING_SOURCE", "english", "SPELLING SOURCE", "Y");
    }

    function init_menu() {
        if (func_num_args()>0) {
            $arg_list = func_get_args();
            $module_id = $arg_list[0];
        }

        module::set_menu($this->module, "Negation Modifiers", "LIBRARIES", "_negation_modifiers");

        // put in more details
        module::set_detail($this->description, $this->version, $this->author, $this->module);
    }

    function init_stats() {
    }

    function init_help() {
    }

    function init_sql() {
        if (func_num_args()>0) {
            $arg_list = func_get_args();
            $module_id = $arg_list[0];
        }

        module::execsql("CREATE TABLE `m_negtracker_modifiers` (".
            "`modifier_id` float NOT NULL auto_increment,".
            "`modifier_str` varchar(150) NOT NULL default '',". // Put it in as regular expression
            "`modifier_known_tags` varchar(100) default '',".   // what other tags does it modify?
            "`modifier_tag_context` varchar(100) default '',".  // how is modifier tagged?
            "`modifier_type` varchar(10) default '',".             // bidirectional, left, right
            "`modifier_algebra` char(1) default 'N',".          // algebraic pattern? no nausea and/or vomiting
            "`modifier_example` varchar(255) default '',".      // example of usage for this modifier
            "PRIMARY KEY  (`modifier_id`), ".
            "UNIQUE INDEX (`modifier_str`,`modifier_type`), ".
            "INDEX (`modifier_str`)".
            ") ENGINE=MyISAM");

        module::execsql("CREATE TABLE `m_negtracker_inventory` (".
            "`document_id` varchar(100) NOT NULL,".
            "`modifier_str` varchar(150) NOT NULL,".
            "`modifier_type` varchar(10) default '',".
            "`tag_context` varchar(150) NOT NULL,".
            "`frequency` integer NOT NULL default '0',".
            "PRIMARY KEY (`document_id`, `modifier_str`, `tag_context`)".
            ") ENGINE=MyISAM");

    }

    function drop_tables() {

        module::execsql("DROP TABLE `m_negtracker_modifiers`;");
        module::execsql("DROP TABLE `m_negtracker_inventory`;");
    }


    // --------------- CUSTOM MODULE FUNCTIONS ------------------

    function negated_concepts() {

        if (func_num_args()) {
            $arg_list = func_get_args();
            $inputstr = $arg_list[0];

            // NO
            $patterns[0] = "/\b([Nn]o_D[DB])(\s?)([a-zA-Z]+_[A-Z]{2,4}_C[0-9]{7})/";
            $patterns[1] = "/\b([Nn]o_D[DB])(\s?)([a-zA-Z]+_JJ)(\s?)([a-zA-Z]+_[A-Z]{2,4}_C[0-9]{7})/";
            $patterns[2] = "/\b([Nn]o_D[DB])(\s?)([a-zA-Z]+_DB)(\s?)([a-zA-Z]+_[A-Z]{2,4}_C[0-9]{7})/";

            // UNLIKELY
            $patterns[3] = "/\b([Uu]nlikely_D[DB])(\s?)/";

            $sentences = preg_split("/(\._\.)|(!_\.)|(\?_\.)/", $inputstr);
            for ($i=0; $i<count($sentences); $i++) {
                for ($j=0; $j<count($patterns); $j++) {
                    if (preg_match_all($patterns[$j], $sentences[$i], $matches)) {
                        //$negated_concepts[] = $sentences[$i];
                        $line_list = implode("\n", $matches[0]);
                        $negated_concepts[] = $line_list;
                    }
                }
            }
            if (count($negated_concepts)>0) {
                return implode("\n",$negated_concepts);
            }
        }
    }

    function _negation_modifiers() {
        if (func_num_args()) {
            $arg_list = func_get_args();

            $menu_id = $arg_list[0];
            $get_vars = $arg_list[1];
            $post_vars = $arg_list[2];
            $textlab = $arg_list[3];

            if ($post_vars["submitdict"]) {
                negtracker::process_manage_modifier($menu_id, $get_vars, $post_vars, $textlab);
            }
            negtracker::form_manage_modifier($menu_id, $get_vars, $post_vars, $textlab);
        }
    }

    function process_manage_modifier() {
        if (func_num_args()) {
            $arg_list = func_get_args();
            $menu_id = $arg_list[0];
            $get_vars = $arg_list[1];
            $post_vars = $arg_list[2];
            $textlab = $arg_list[3];

            switch ($post_vars["submitdict"]) {
            case "Add Modifier":
                break;
            case "Update Modifier":
                break;
            case "Delete Modifier":
                break;
            case "Cancel":
                break;
            }
        }
    }

    function form_manage_modifier() {
        if (func_num_args()) {
            $arg_list = func_get_args();
            $menu_id = $arg_list[0];
            $get_vars = $arg_list[1];
            $post_vars = $arg_list[2];
            $textlab = $arg_list[3];

            $term = $get_vars["spellcheck"];

            print "<a name='spellcheck'>";
            print "<span class='newstitle'>".FTITLE_SPELLING_CHECK."</span><br>";
            print "<span class='tinylight'>".INSTR_SPELLING_CHECK."</span><br>";
            print "<table width='450' cellpadding='5' cellspacing='1' style='border: 1px solid black'>";
            print "<form action = '".$_SERVER["SELF"]."?page=PROCESSING&menu_id=".$get_vars["menu_id"].($get_vars["document_id"]?"&document_id=".$get_vars["document_id"]:"")."&tab=".$get_vars["tab"]."&spellcheck=".$get_vars["spellcheck"]."#spellcheck' name='form_manage_term' method='post'>";
            print "<tr valign='top'><td>";
            print "<table cellpadding='2' cellspacing='1'>";
            print "<tr><td>";
            print "<span class='boxtitle'>".LBL_SPELLING_SOURCE."</span><br> ";
            $post_vars["spellsource"] = (isset($post_vars["spellsource"])?$post_vars["spellsource"]:"L"); // Lexicon is default source
            print "<input type='radio' name='spellsource' value='P' ".($post_vars["spellsource"]=="P"?"checked":"")."'> PSpell<br>";
            print "<input type='radio' name='spellsource' value='L' ".($post_vars["spellsource"]=="L"?"checked":"")."'> UMLS Lexicon<br>";
            print "</td></tr>";
            print "<tr><td>";
            print "<span class='boxtitle'>".LBL_POSSIBLE_MISPELLED."</span><br> ";
            print "<input type='text' class='textbox' size='20' maxlength='20' name='misspelled' value='".($term?$term:$post_vars["misspelled"])."' style='border: 1px solid #000000'><br>";
            print "</td></tr>";
            print "<tr><td>";
            print "<span class='boxtitle'>".LBL_POSSIBLE_CORRECTIONS."</span><br> ";
            if ($word_list = spelling::word_list($menu_id, $post_vars, $get_vars, $term)) {
                print "<span class='tinylight'>".INSTR_SPELLCORRECTION_LIST."</span><br>";
                print "<select size='10' name='correction_list'>";
                foreach ($word_list as $key=>$value) {
                    print "<option value='$value'>".$value."</option>";
                }
                print "</select>";
            } else {
                print "<font color='red'>None</font>";
            }
            print "</td></tr>";
            print "<tr><td><br>";
            print "<span class='boxtitle'>".LBL_REPLACEMENT_TERM."</span><br> ";
            print "<input type='text' class='textbox' size='20' maxlength='20' name='replacement' value='".($term?$term:$post_vars["misspelled"])."' style='border: 1px solid #000000'><br>";
            print "</td></tr>";
            print "</table>";
            print "</td><td>";
            print "<table cellpadding='2' cellspacing='1'>";
            print "<tr><td>";
            print "<input type='hidden' name='spellcheck' value='".$get_vars["spellcheck"]."'>";
            print "<input type='hidden' name='cleaned_text' value='".$textlab["cleaned"]."'>";
            print "<input type='submit' value = 'Change Dictionary' class='textbox' name='submitdict' title='Changes dictionary used for spelling check.' style='border: 1px solid #000000'> ";
            print "</td></tr>";
            print "<tr><td>";
            print "<input type='submit' value = 'Add to Dictionary' class='textbox' name='submitdict' title='Adds to the dictionary the word from the MISSPELLED WORD field.' style='border: 1px solid #000000'> ";
            print "</td></tr>";
            print "<tr><td>";
            print "<input type='submit' value = 'Replace from Correction List' class='textbox' name='submitdict' title='Replaces misspelled word with word selected from the CORRECTION LIST.' style='border: 1px solid #000000'> ";
            print "</td></tr>";
            print "<tr><td>";
            print "<input type='submit' value = 'Replace using Replacement Term' class='textbox' name='submitdict' title='Replaces misspelled word with word selected from the REPLACEMENT TERM field.' style='border: 1px solid #000000'> ";
            print "</td></tr>";
            print "<tr><td>";
            print "<input type='submit' value = 'Add to Ignore List' class='textbox' name='submitdict' title='Adds the word in the MISPELLED WORD field to the Ignore list.' style='border: 1px solid #000000'> ";
            print "</td></tr>";
            print "<tr><td>";
            print "<input type='submit' value = 'Cancel' class='textbox' name='submitdict' style='border: 1px solid #000000'> ";
            print "</td></tr>";
            print "</table>";
            print "</td></tr>";
            print "</form>";
            print "</table>";
        }
    }

}

/** ************************************************
** NEGATION CLASS
** $Author: Herman Tolentino MD
** $Last update: 10/02/05
**
** OBJECTIVE: Process one document at a time for
** negation phrases that affect concepts.
**
** Word list for negation and source code ideas were
** obtained from the work of Wendy Chapman using
** Negex (written in Python).
**
*/
class negation {

    var $inputstring;
    var $sentences;
    var $deep_parse;
    var $array_nega;
    var $array_negb;
    var $array_pnega;
    var $array_pnegb;
    var $array_conj;
    var $array_pseudoneg;
    var $negphrase;

    function negation($inputstring) {

        $this->inputstring = $inputstring;
        $this->partition();
        $this->catch_phrase();
        $this->load_dict();
        $this->scrutinize();
    }

    function partition() {
        $this->sentences = preg_split("/(\._\.)|(!_\.)|(\?_\.)|(-_SYM)|(-_:)/", $this->inputstring);
    }

    function catch_phrase() {

        $pattern[0] = "/\b(absence_)/";
        $pattern[1] = "/\b(cannot_)/";
        $pattern[2] = "/\b(decline_)/";
        $pattern[3] = "/\b(den)(y|ies|ied)(_)/";
        $pattern[4] = "/\b(fail_)/";
        $pattern[5] = "/\b(free_)/";
        $pattern[6] = "/\b(negative_)/";
        $pattern[7] = "/\b(never_)/";
        $pattern[8] = "/\b(not|no)(_)/";
        $pattern[9] = "/\b(with|without)(_)/";
        $pattern[10] = "/\b(rule[sd]_)/";
        $pattern[11] = "/\b(unlikely_)/";
        for($i=0; $i<count($this->sentences); $i++) {
            for($j=0; $j<count($pattern); $j++) {
                if (preg_match_all($pattern[$j], $this->sentences[$i], $matches)) {
                    $this->deep_parse[] = $this->sentences[$i];
                }
            }
        }
        if (is_array($this->deep_parse)) {
            $this->deep_parse = array_unique($this->deep_parse);
        }

    }

    function load_dict() {

        $sql = "select modifier_str, modifier_type from m_negtracker_modifiers order by modifier_type";
        if ($result = mysql_query($sql)) {
            if (mysql_num_rows($result)) {
                while (list($modifier, $type) = mysql_fetch_array($result)) {
                    switch ($type) {
                    case "NEGA":
                        $this->array_nega[] = $modifier;
                        break;
                    case "NEGB":
                        $this->array_negb[] = $modifier;
                        break;
                    case "PNEGA":
                        $this->array_pnega[] = $modifier;
                        break;
                    case "PNEGB":
                        $this->array_pnegb[] = $modifier;
                        break;
                    case "PSEUDONEG":
                        $this->array_pseudoneg[] = $modifier;
                        break;
                    case "CONJ":
                        $this->array_conj[] = $modifier;
                        break;
                    }
                }
            }
        }
    }

    function scrutinize() {

        foreach($this->deep_parse as $key => $sentence) {
            $temp = preg_split("/(\s+|,_,)/", $sentence);
            for($i=0; $i<count($temp); $i++) {
                if (strlen($temp[$i])>0) {
                    $tokens[] = $temp[$i];
                }
            }
            $stripped = $this->remove_tags($sentence);
            //print $stripped."<br><br>";
            for($i=0; $i<count($tokens); $i++) {
                $mytoken = new token($tokens[$i]);
                $term = $mytoken->get_term();
                $tag = $mytoken->get_tag();
                $cui = $mytoken->get_cui();
                if ($negtype = $this->is_negation($term)) {
                    print "$negtype<br>";
                    $negphrase = $this->negation_phrase($sentence, $term, $negtype);
                    foreach($negphrase as $value) {
                        $this->negphrase[] = $value;
                    }
                        print "negation phrase: ".nl2br(implode("\n", $negphrase))."<br>";
                } else {
                }
            }
        }
    }

    function remove_tags($sentence) {

        $tokens = explode(" ", $sentence);
        for($i=0; $i<count($tokens); $i++) {
            $token = new token($tokens[$i]);
            $stripped[] = $token->get_term();
        }
        return implode(" ", $stripped);
    }

    function sentence_split($sentence) {
        foreach($this->array_conj as $conj) {
            if ($phrase = preg_split("/(".$conj.")(_)([A-Z]{0,3})/")) {
                return $phrase;
            }
        }
    }

    function regex($term) {

        $first = substr($term, 0,1);
        $ucfirst = substr(ucfirst($term), 0,1);
        $rest = substr($term, 1, strlen($term)-1);
        $regex = "[".$ucfirst.$first."]".$rest;
        return $regex;
    }

    function negation_phrase($sentence, $term, $negtype) {

        if ($this->is_stop($sentence)) {
            $phrases[] = sentence_split($sentence);
        } elseif (preg_match("/(,_,)/", $sentence)) {
            $phrases = preg_split("/(,_,)/", $sentence);
        } else {
            $phrases[] = $sentence;
        }
        foreach ($phrases as $phrase) {
            switch($negtype) {
            case "NEGA":
                $tokens = explode(" ", $phrase);
                $stop =$start = false;
                $negphrase = array();
                for($i=0; $i<count($tokens); $i++) {

                    if (preg_match("\b/(".$this->regex($term).")/", $tokens[$i])) {
                        $start = true;
                        $negphrase[] = $tokens[$i];
                    }
                    if (preg_match("/(to_II)/", $tokens[$i])) {
                        break;
                    }
                }
                print_r($negphrase);

                //preg_match("/\b(".$this->regex($term)."_)(.*)([A-Za-z-0-9]_(NN.*|JJ.*|RR.*|VV.*)_C[0-9]+)/", $phrase, $matches);
                $retval[] = implode(" ", $negphrase);
                break;

            case "NEGB":
                break;
            }
        }
        return $retval;
    }

    function is_stop($term) {
        if (array_search($term, $this->array_conj)) {
            return true;
        }
        return false;
    }

    function is_negation($term) {

        if (array_search($term, $this->array_nega)) {
            return "NEGA";
        }
        if (array_search($term, $this->array_negb)) {
            return "NEGB";
        }
        if (array_search($term, $this->array_pnega)) {
            return "PNEGA";
        }
        if (array_search($term, $this->array_pnegb)) {
            return "PNEGB";
        }
        if (array_search($term, $this->array_pseudoneg)) {
            return "PSEUDONEG";
        }
        return false;
    }
}

?>
