<?
class ontomap extends module {

    //
    // Author: Herman Tolentino (unless specified)
    //
    // AEFI NLP Project
    // Vaccine Analytic Unit - Brighton Collaboration - National Library of Medicine
    //
    // IMPORTANT:
    // This assumes that the RAP is installed in the home directory of this application and is
    // defined in the constant RDFAPI_INCLUDE_DIR in index.php. RAP was created by Chris Bizer.
    //

    function ontomap() {
        //
        // do not forget to update version
        //
        $this->author = 'Herman Tolentino MD';
        $this->version = "0.1-".date("Y-m-d");
        $this->module = "ontomap";
        $this->description = "AEFI Module - Ontology Class";
        // 0.1: BEGIN

        $this->ontology_home = '';

    }

    function init_deps() {
    //
    // insert dependencies in module_dependencies
    //
        module::set_dep($this->module, "module");

    }

    function init_lang() {
    //
    // insert necessary language directives
    //
    }

    function init_menu() {
        if (func_num_args()>0) {
            $arg_list = func_get_args();
            $module_id = $arg_list[0];
        }

        module::set_menu($this->module, "Manage Ontology", "ONTOLOGY", "_build_ont");
        module::set_menu($this->module, "Query Ontology", "ONTOLOGY", "_query_ont");

        // put in more details
        module::set_detail($this->description, $this->version, $this->author, $this->module);
    }

    function init_stats() {
    }

    function init_help() {
    }

    function init_sql() {
    //
    // use RAP table generation
    //
        $rdf_database = new DbStore('MySQL', 'localhost', 'game', 'root', '' );
        $rdf_database->createTables('MySQL');
    }

    function drop_tables() {

        module::execsql("DROP TABLE `statements`;");
        module::execsql("DROP TABLE `namespaces`;");
        module::execsql("DROP TABLE `models`;");
        module::execsql("DROP TABLE `datasets`;");
        module::execsql("DROP TABLE `dataset_model`;");

    }


    // --------------- CUSTOM MODULE FUNCTIONS ------------------

    function set_ontology_home($base_uri) {
        if ($base_uri) {
            $this->ontology_home = $base_uri;
            return true;
        }
    }

    function _query_ont() {

        /*
        $base = './game/ont/aefi.rdf';
        $n3file = './game/ont/aefi.n3';
        $o = new ontology();
        $o->set_base($base);
        $triples = $o->get_triples();
        $graph = new graphviz($triples);
        $graph->filename("aefi.dot");
        $graph->set_tool("dot");
        $graph->set_overlap("true");
        $graph->set_size("700,700");
        $graph->write_dot();
        $graph->draw();
        */

        $base = './game/ont/crying.rdf';
        $o = new ontology();
        $o->set_base($base);
        $triples = $o->get_triples();
        $graph = new graphviz($triples);
        $graph->filename("crying.dot");
        $graph->set_tool("dot");
        $graph->set_nodesep(0.2);
        $graph->set_size("20,20");
        $graph->write_dot();
        $graph->draw();

            $query = "SELECT ?x ".
                     "WHERE ".
                     "(?x s:has_Certainty_ID ?level) ".
                     "(?level rdf:value \"LEVEL1\") ".
                     "USING aefi FOR <http://localhost/softlab/game/ont/aefi.rdf#> ".
                     "s FOR <http://localhost/softlab/game/ont/pg_seizure.rdf#> ".
                     "xsd FOR <http://www.w3.org/2001/XMLSchema#> ".
                     "rdfs FOR <http://www.w3.org/2000/01/rdf-schema#> ".
                     "rdf FOR <http://www.w3.org/1999/02/22-rdf-syntax-ns#> ".
                     "owl FOR <http://www.w3.org/2002/07/owl#>";

        $base = './game/ont/pg_seizure.rdf';
        $o = new ontology();
        $o->set_base($base);
        $triples = $o->query($query);

        $base = './game/ont/pg_seizure.rdf';
        $o = new ontology();
        $o->set_base($base);
        $triples = $o->get_triples();
        $graph = new graphviz($triples);
        $graph->filename("pg_seizure2.dot");
        $graph->set_tool("dot");
        $graph->set_rankdir("LR");
        $graph->set_nodesep(0.2);
        $graph->set_size("400,400");
        $graph->write_dot();
        $graph->draw();

        $base = './game/ont/fever.rdf';
        $o = new ontology();
        $o->set_base($base);
        $triples = $o->get_triples();
        $graph = new graphviz($triples);
        $graph->filename("fever.dot");
        $graph->set_tool("dot");
        $graph->set_nodesep(0.2);
        $graph->set_size("700,700");
        $graph->write_dot();
        $graph->draw();

        $base = './game/ont/nodule.rdf';
        $o = new ontology();
        $o->set_base($base);
        $triples = $o->get_triples();
        $graph = new graphviz($triples);
        $graph->filename("nodule.dot");
        $graph->set_tool("dot");
        $graph->set_nodesep(0.2);
        $graph->set_size("700,700");
        $graph->write_dot();
        $graph->draw();

        $base = './game/ont/hhe.rdf';
        $o = new ontology();
        $o->set_base($base);
        $triples = $o->get_triples();
        $graph = new graphviz($triples);
        $graph->filename("hhe.dot");
        $graph->set_tool("dot");
        $graph->set_nodesep(0.2);
        $graph->set_size("700,700");
        $graph->write_dot();
        $graph->draw();
    }

    function form_query_ont() {
    }

    function display_query_ont() {
    }

    function process_query_ont() {
    }

}
/** ************************************************
** AEFI CLASS
** $Author: Herman Tolentino MD
** $Last update: 10/03/05
**
** OBJECTIVE: Class maps document to ontology.
**
*/
class aefi {

    var $ssx_array;
    var $complaint_array;
    var $provider_array;

    function aefi() {
    }

    function is_immunologic_factor($parm) {

        if (preg_match("/\b(C[0-9]{7})/", $parm)) {
            $cui = $parm;
        } else {
            $token = new token($parm);
            $cui = $token->get_cui();
        }
        $sql = "select TUI from umls.MRSTY where CUI = '$cui' and TUI = 'T129'";
        if ($result = mysql_query($sql)) {
            if (mysql_num_rows($result)) {
                return true;
            }
        }
        return false;
    }

    function is_ssx($parm) {

        if (preg_match("/\b(C[0-9]{7})/", $parm)) {
            $cui = $parm;
        } else {
            $token = new token($parm);
            $cui = $token->get_cui();
        }
        $sql = "select TUI from umls.MRSTY where CUI = '$cui' and (TUI = 'T184' or TUI = 'T046' or TUI = 'T080' or TUI = 'T047')";
        if ($result = mysql_query($sql)) {
            if (mysql_num_rows($result)) {
                return true;
            }
        }
        return false;
    }

    function is_bodypart($parm) {

        if (preg_match("/\b(C[0-9]{7})/", $parm)) {
            $cui = $parm;
        } else {
            $token = new token($parm);
            $cui = $token->get_cui();
        }
        $sql = "select TUI from umls.MRSTY where CUI = '$cui' and (TUI = 'T023' or TUI='T029')";
        if ($result = mysql_query($sql)) {
            if (mysql_num_rows($result)) {
                return true;
            }
        }
        return false;
    }
}

/** ************************************************
** VACCINE CLASS
** $Author: Herman Tolentino MD
** $Last update: 11/28/05
**
** OBJECTIVE: Vaccine Parser.
**
*/
class vaccine {

    var $phrasetokens;
    var $sentences;
    var $sentence_count;
    var $candidate_parse;
    var $state;
    var $negated_concepts;
    var $stack;

    function vaccine($inputstring, $inputphrases) {

        $this->phrases = $this->partition_phrase($inputphrases);
        $this->sentences = $this->partition_string($inputstring);
        for ($i=0; $i<count($this->sentences); $i++) {
            $this->vaccine_patterns($this->sentences[$i]);
        }
    }

    function partition_phrase($inputphrases) {
        $tokens = preg_split("/(\s+)/", $inputphrases);
        foreach ($tokens as $token) {
            $fragments = preg_split("/(_)/", $token);
            $cui = $fragments[2];
            $terms = preg_split("/(\|)/", $fragments[0]);
            $phrasetokens[] = array("phrase"=>$fragments[0], "terms"=>$terms, "cui"=>$cui);
        }
        return $phrasetokens;
    }

    function partition_string($inputstring) {
        return preg_split("/(\._\.)|(!_\.)|(\?_\.)|(-_SYM)|(-_:)/", $inputstring);
    }

    function vaccine_patterns($sentence) {

        $patterns[0] = "/([Ff]ollowing_VVG_C0332282)(.*)(immunization_NN_C0020971|vaccine_NN_C0042210)/";
        $patterns[1] = "/(regarding_VVGJ completion_NN of_II_C0332285 )(.*)(series_NN_C0205549)/";
        $patterns[2] = "/(receiving_VVG) meningococcal_JJ_C0700144 C_NN_C0439106/";
        $patterns[3] = "/(received_VVD)(.*)(vaccine_NN_C0042210|immunization_NN_C0020971)/";
        foreach ($patterns as $pattern) {
            if (preg_match($pattern, $sentence, $matches)) {
                $this->deep_parse($sentence, $pattern, $matches);
            }
        }
    }

    function deep_parse($sentence, $pattern, $matches) {

        $this->state = "START";
        print "<font color='blue'>PARSING: ".$sentence."</font><br>";

        while ($this->state<>"EOS") {

            print "STATE: <font color='red'>".$this->state."</font><br>";

            switch ($this->state) {
            case "START":
                $this->state = "EOS";
                break;
            }

        }
    }

}

/** ************************************************
** ONTOLOGY CLASS
** $Author: Herman Tolentino MD
** $Last update: 10/03/05
**
** OBJECTIVE: Class wraps RAP function calls.
**
*/
class ontology {

    var $base_uri;
    var $array_summary;
    var $model;
    var $encounter;

    function ontology () {
        $this->encounter = array();
        $this->model = new MemModel();
    }

    function n3toRDF($n3file) {
        $f = fopen($n3file, "r");
        while (!feof($f)) {
            $contents .= fread($f, 8192);
        }
        print $contents;
    }

    function set_base($base_uri) {
        $this->base_uri = $base_uri;
        $this->model->load($this->base_uri);
    }

    function get_stype($searchtype) {

        $query = "SELECT ?resource, ?value ".
                 "WHERE ".
                 "(?resource aefi:has_STYPE ?value) ".
                 "USING aefi FOR <http://www.owl-ontologies.com/unnamed.owl#> ";
        $res = $this->model->rdqlQuery($query);
        foreach ($res as $key=>$value) {
            if ($searchtype == $res[$key]["?value"]->label) {
                list($url, $resource) = explode("#", $res[$key]["?resource"]->uri);
                return $resource;
            }
        }
    }

    function get_concept($searchconcept) {
        $query = "SELECT ?resource, ?value ".
                 "WHERE ".
                 "(?resource, aefi:has_CUI, ?value) ".
                 "USING aefi FOR <http://www.owl-ontologies.com/unnamed.owl#> ";
        $res = $this->model->rdqlQuery($query);
    }

    function get_triples() {
            $query = "SELECT ?x, ?y, ?z ".
                     "WHERE ".
                     "(?x, ?y, ?z) ".
                     "USING aefi FOR <http://localhost/softlab/game/ont/aefi.rdf#> ".
                     "xsd FOR <http://www.w3.org/2001/XMLSchema#> ".
                     "rdfs FOR <http://www.w3.org/2000/01/rdf-schema#> ".
                     "rdf FOR <http://www.w3.org/1999/02/22-rdf-syntax-ns#> ".
                     "owl FOR <http://www.w3.org/2002/07/owl#>";
        $res = $this->model->rdqlQuery($query);
        foreach ($res as $key=>$value) {
            list($url, $subject) = explode("#", $res[$key]["?x"]->uri);
            if (!$subject) {
                $parts = explode("/", $res[$key]["?x"]->uri);
                $count = count($parts);
                $subject = $parts[$count-1];
                $subject = preg_replace("/([.])/", "_", $subject);
                $graph_title = $subject;
            }
            list($url, $predicate) = explode("#", $res[$key]["?y"]->uri);
            list($url, $object) = explode("#", $res[$key]["?z"]->uri);
            $literal = $res[$key]["?z"]->label;
            $object = ($object?$object:$literal);
            $dot_array[] = array("subject"=>$subject,"predicate"=>$predicate,"object"=>$object);
        }
        return $dot_array;
    }

    function query($query) {
        $res = $this->model->rdqlQuery($query);
        print_r($res);
    }

}

/** ************************************************
** GRAPHVIZ CLASS
** $Author: Herman Tolentino MD
** $Last update: 10/03/05
**
** OBJECTIVE: Class wraps graphviz tools and parameters.
**
*/
class graphviz {

    var $triples;
    var $filename;
    var $option;
    var $tool;
    var $overlap;
    var $size;
    var $node_fontname;
    var $edge_fontname;
    var $node_fontsize;
    var $edge_fontsize;
    var $nodesep;
    var $rankdir;

    function graphviz($triples) {
        $this->triples = $triples;
        $this->option = array();
        $this->set_size();
        $this->set_node_fontname();
        $this->set_node_fontsize();
        $this->set_edge_fontname();
        $this->set_edge_fontsize();
        $this->set_node_color();
        $this->set_overlap();
        $this->set_nodesep();
        $this->set_rankdir();
    }

    function filename($file = "test.dot") {
    // $filename is name of dot file to be written
    // format: name.dot
        $this->filename = $file;
    }

    function set_tool($tool = "dot") {
    // $tool is either 'dot' or 'neato'
    // see graphviz documentation
    //
        $this->tool = $tool;
    }

    function set_nodesep($nodesep = 0.5) {
    // inches
        $this->nodesep = $nodesep;
    }

    function set_rankdir($rankdir = "TB") {

        $this->rankdir = $rankdir;
    }

    function set_node_fontname($nodefont = "Helvetica") {
        $this->node_fontname = $nodefont;
    }

    function set_edge_fontname($edgefont = "Helvetica") {
        $this->edge_fontname = $edgefont;
    }

    function set_node_fontsize($nodesize = 10) {
        $this->node_fontsize = $nodesize;
    }

    function set_edge_fontsize($edgesize = 10) {
        $this->edge_fontsize = $edgesize;
    }

    function set_node_color($nodecolor = "lightblue") {
        $this->node_color = $nodecolor;
    }

    function set_overlap($overlap = true) {
        $this->overlap = $overlap;
    }

    function set_size($size = "10,10") {
    // canvas size in inches
        $this->size = $size;
    }

    function option($param, $value) {
        $option["$param"] = true;
    }

    function write_dot() {

        $dot .= "digraph unix {\n".
                "\trankdir=".$this->rankdir."\n".
                "\tnode [color=".$this->node_color.", style=\"filled\", fontname=".$this->node_fontname.", fontsize=".$this->node_fontsize."]\n".
                "\tgraph [fontname=Helvetica]\n".
                "\tedge [fontname=".$this->edge_fontname." fontsize=".$this->edge_fontsize." len=1.5]\n".
                "\tsize=\"".$this->size."\" \n".
                "\tmindist=1\n".
                "\tnodesep=".$this->nodesep."\n".
                "\tpackmode='graph'\n".
                "\toverlap=\"".$this->overlap."\"\n".
                "\tsplines=true\n".
                "\tcenter=\"\" \n";
        for ($i=0; $i < count($this->triples); $i++) {
            $subject = $this->triples[$i]["subject"];
            $predicate = $this->triples[$i]["predicate"];
            $object = $this->triples[$i]["object"];
            //list($subject, $predicate, $object) = explode("||", $this->triples[$i]) ;
            if (strlen($predicate)>0) {
                $dot .= "\t\"$subject\" -> \"$object\" [ label = \"$predicate\"];\n";
            } else {
                $dot .= "\t\"$subject\" -> \"$object\";\n";
            }
        }
        $dot .= "}";
        //print nl2br($dot);
        $filename = getcwd()."/".GAME_GRAPH_DIR."/".$this->filename;
        $f = fopen($filename,"w+");
        if (fwrite($f, $dot)) {
            fclose($f);
        }
        $this->process($filename);
    }

    function process($file) {
    // pass on to command line
        $commandstring = GRAPHVIZ_DIR."/".$this->tool." -Tpng $file -o ".$file.".png";
        // The following is a backtick operator.
        // Graphviz 'dot' apparently does not work with any
        // other shell execution commands.
        `$commandstring`;
    }

    function draw() {

        print "<img src='./".GAME_GRAPH_DIR."/".$this->filename.".png'>";
    }
}

/** ************************************************
** SENSOR CLASS
** $Author: Herman Tolentino MD
** $Last update: 10/03/05
**
**
*/

class sensor {

    var $indicator;
    var $category;
    var $relations;

    function sensor() {
    }


}

?>
