<?php
// ----------------------------------------------------------------------------------
// PHP Script: test_ManipulatingDbModel.php
// ----------------------------------------------------------------------------------

/*
 * This is an online demo of RAP's database backend.
 * This script demonstrates some methods to manipulate a DbModel.
 *
 * History:
 * 30-07-2003                : First version of this demo.
 *
 * @author Radoslaw Oldakowski <radol@gmx.de>
 */
?>


<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN">
<html>
<head>
	<title>Test Store Models in Database</title>
</head>
<body>

<?php

// Include RAP
define("RDFAPI_INCLUDE_DIR", "./../api/");
include(RDFAPI_INCLUDE_DIR . "RdfAPI.php");


## 1. Connect to MsAccess database (via ODBC)
## ------------------------------------------

// Connect to MsAccess (rdf_db DSN) database using connection settings
// defined in constants.php :
$rdf_database = new DbStore();


## 2. Load a DbModel
## -----------------
$dbModel = $rdf_database->getModel("example1.rdf");

// Output the model as HTML table
$dbModel->writeAsHtmlTable();

echo "<br><br>";

## 3. Add a statement tho the DbModel
## ----------------------------------

// Ceate a new statement
$statement = new Statement(new Resource("http://www.w3.org/Home/Lassila"),
                           new Resource("http://description.org/schema/Description"),
                           new Literal("Lassilas persnliche Homepage", "de"));
                           
// Add the statement to the DbModel
$dbModel->add($statement);

// Output the string serialization of the DbModel
echo $dbModel->toStringIncludingTriples();

echo "<br><br>";


## 4. Search statements
## ---------------------

// Search for statements having object $literal
$literal = new Literal("Lassilas persnliche Homepage", "de");
$res = $dbModel->find(NULL, NULL, $literal);

//  Output the result
$res->writeAsHtmlTable();

echo "<br>";


## 5. 5. Replace nodes and serialize the DbModel to XML/RDF
## --------------------------------------------------------

// replace a literal
$dbModel->replace(NULL, NULL, new Literal("Lassilas persnliche Homepage", "de"),
                              new Literal ("Lassila's personal Homepage", "en"));

// Serialize to RDF
$dbModel->writeAsHtml();

echo "<br><br>";


## 6. Remove a statement
## ---------------------

$dbModel->remove(new Statement (new Resource("http://www.w3.org/Home/Lassila"),
                                new Resource("http://description.org/schema/Description"),
                                new Literal ("Lassila's personal Homepage", "en")));

// Output the DbModel
$dbModel->writeAsHtmlTable();

echo "<br>";


## 7. Generate a MemModel and compare both models
## ----------------------------------------------

// Generate a MemModel
$memModel = $dbModel->getMemModel();

// Compare this DbModel withe the generated MemModel
$res = $dbModel->equals($memModel);

if ($res)
   echo "models are equal";
else
   echo "models are different";

echo "<br>";


## 8. Save DbModel to file
## ----------------------------------------------

// Save DbModel to file (XML/RDF)
$dbModel->saveAs("Output.rdf");

// Save DbModel to file (N3)
$dbModel->saveAs("Output.n3");

// close the DbModel
$dbModel->close();

?>

</body>
</html>
