/********************************************************************************************************

   Using SAS with the 2024 National Ambulatory Medical Care Survey Health Center (NAMCS HC) Component
   Public Use Data File

   Please follow the steps below to load the 2024 NAMCS HC Component public use data file into SAS.
   It will create descriptive variable labels and formats with category labels.

   1. Create a new folder on your local workstation, for example, C:\namcshc2024.

   2. Download the namcshc2024_sas.sas7bdat file from the website and save to the folder C:\namcshc2024.

   Please note that this program will replace the dataset 
   in the default directory, if one is present.

   For details and guidance on how to properly conduct statistical analyses
   with these data, including the appropriate use of weights to create
   nationally representative estimates, please refer to the technical
   documentation that accompanies the 2024 NAMCS HC Component.

   For any questions, suggestions, or comments concerning NAMCS HC Component data, please
   contact the Division of Health Care Statistics at ambcare@cdc.gov.

********************************************************************************************************/

* Set the Libname Statement to Your File Location;
LIBNAME in1 "C:\namcshc2024"; 

* Create a Temporary Working File Copied from the Unzipped File;
DATA hc24;
	SET in1.namcshc2024_sas;  
RUN;

* Display Contents of Data File Before Applying Labels and Formats;
PROC CONTENTS DATA=hc24;
RUN;

* Define Value Formats;
PROC FORMAT;
   VALUE AGEF
		-9 = "Missing"
		89 = "89+"				
;

   VALUE AGEGROUPF
		-9 = "Missing"
		 1 = "Less than 18 years"	
		 2 = "18-44 years"
		 3 = "45-64 years"	
		 4 = "65 years or more"		
;

   VALUE AGEMONTHF
		-9 = "Missing"
		-7 = "Not applicable, patient 1 year or older"
		 1 = "1 month"	
		 2 = "2 months"
		 3 = "3 months"	
		 4 = "4 months"	
		 5 = "5 months"
		 6 = "6 months"	
		 7 = "7 months"	
		 8 = "8 months"
		 9 = "9 months"	
		 10 = "10 months"
		 11 = "11 months"	
;

	VALUE SEXF
		-9 = "Missing"
		 1 = "Male"
		 2 = "Female"
;

	VALUE MONTHF
		-9 = "Missing"
		 1 = "January"
		 2 = "February"
		 3 = "March"
		 4 = "April"
		 5 = "May"
		 6 = "June"
		 7 = "July"
		 8 = "August"
		 9 = "September"
		10 = "October"
		11 = "November"
		12 = "December" 
;

	VALUE DAYF
		-9 = "Missing"
		 1 = "Sunday"
		 2 = "Monday"
		 3 = "Tuesday"
		 4 = "Wednesday"
		 5 = "Thursday"
		 6 = "Friday"
		 7 = "Saturday" 
;

	VALUE $MARITALF
		"-9" = "Missing"
		 "D" = "Divorced"
		 "L" = "Legally Separated"
		 "M" = "Married"
		 "O" = "Other"
		 "S" = "Single"
		 "T" = "Domestic Partnership"
		 "U" = "Unmarried" 
		 "W" = "Widowed" 
;

	VALUE ETHNICITYF
		-9 = "Missing"
		 1 = "Hispanic or Latino"
		 2 = "Not Hispanic or Latino" 
;

	VALUE RACEF
		-9 = "Missing"
		 1 = "Asian"
		 2 = "Black or African American"
		 3 = "White"
		 4 = "Other or multiple races"
;

	VALUE RACERETHF
		-9 = "Missing"
		 1 = "White, non-Hispanic"
		 2 = "Black, non-Hispanic"
		 3 = "Hispanic"
		 4 = "Other, non-Hispanic"
;

	VALUE DXTYPEF
		-9 = "Missing"
		 1 = "Primary"
		 2 = "Non-Primary"
;

RUN;

* Label Variables and Apply Formats;
* This will overwrite the hc24 dataset in your working library;
* If you want to create a new working dataset, please rename the dataset in the DATA line;
DATA hc24;
	SET hc24;

	LABEL
		PUF_ID="Public Use File (PUF) unique visit identifier"
		HCID_S="Scrambled health center identifier"
		DAY="Day of the week of visits"
		MONTH="Month of visit"
		YEAR="Survey year"
		MARITAL="Patient marital status"
		AGE="Patient age in years"
		AGE_GROUP="Patient age group"
		AGE_U1_MONTH="Age in months for patients less than 1 year old"
		ETHNICITY="Patient Hispanic ethnicity"
		RACE="Patient race"
		RACERETH="Patient race and Hispanic ethnicity"
		SEX="Patient sex"
		VISWT="Visit weight"
		STRATUM_S="Scrambled stratum of health center"
		DX1="Diagnosis #1 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX2="Diagnosis #2 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX3="Diagnosis #3 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX4="Diagnosis #4 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX5="Diagnosis #5 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX6="Diagnosis #6 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX7="Diagnosis #7 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX8="Diagnosis #8 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX9="Diagnosis #9 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX10="Diagnosis #10 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX11="Diagnosis #11 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX12="Diagnosis #12 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX13="Diagnosis #13 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX14="Diagnosis #14 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX15="Diagnosis #15 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX16="Diagnosis #16 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX17="Diagnosis #17 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX18="Diagnosis #18 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX19="Diagnosis #19 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX20="Diagnosis #20 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX21="Diagnosis #21 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX22="Diagnosis #22 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX23="Diagnosis #23 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX24="Diagnosis #24 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX25="Diagnosis #25 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX26="Diagnosis #26 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX27="Diagnosis #27 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX28="Diagnosis #28 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX29="Diagnosis #29 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX30="Diagnosis #30 (ICD-10-CM), truncated to 4 characters (no decimal)"
		DX_TYPE1="Diagnosis #1 type, either primary or non-primary"
		DX_TYPE2="Diagnosis #2 type, either primary or non-primary"
		DX_TYPE3="Diagnosis #3 type, either primary or non-primary"
		DX_TYPE4="Diagnosis #4 type, either primary or non-primary"
		DX_TYPE5="Diagnosis #5 type, either primary or non-primary"
		DX_TYPE6="Diagnosis #6 type, either primary or non-primary"
		DX_TYPE7="Diagnosis #7 type, either primary or non-primary"
		DX_TYPE8="Diagnosis #8 type, either primary or non-primary"
		DX_TYPE9="Diagnosis #9 type, either primary or non-primary"
		DX_TYPE10="Diagnosis #10 type, either primary or non-primary"
		DX_TYPE11="Diagnosis #11 type, either primary or non-primary"
		DX_TYPE12="Diagnosis #12 type, either primary or non-primary"
		DX_TYPE13="Diagnosis #13 type, either primary or non-primary"
		DX_TYPE14="Diagnosis #14 type, either primary or non-primary"
		DX_TYPE15="Diagnosis #15 type, either primary or non-primary"
		DX_TYPE16="Diagnosis #16 type, either primary or non-primary"
		DX_TYPE17="Diagnosis #17 type, either primary or non-primary"
		DX_TYPE18="Diagnosis #18 type, either primary or non-primary"
		DX_TYPE19="Diagnosis #19 type, either primary or non-primary"
		DX_TYPE20="Diagnosis #20 type, either primary or non-primary"
		DX_TYPE21="Diagnosis #21 type, either primary or non-primary"
		DX_TYPE22="Diagnosis #22 type, either primary or non-primary"
		DX_TYPE23="Diagnosis #23 type, either primary or non-primary"
		DX_TYPE24="Diagnosis #24 type, either primary or non-primary"
		DX_TYPE25="Diagnosis #25 type, either primary or non-primary"
		DX_TYPE26="Diagnosis #26 type, either primary or non-primary"
		DX_TYPE27="Diagnosis #27 type, either primary or non-primary"
		DX_TYPE28="Diagnosis #28 type, either primary or non-primary"
		DX_TYPE29="Diagnosis #29 type, either primary or non-primary"
		DX_TYPE30="Diagnosis #30 type, either primary or non-primary"
	;

	FORMAT
		AGE AGEF.
		AGE_GROUP AGEGROUPF.
		AGE_U1_MONTH AGEMONTHF.
		SEX SEXF.
		MARITAL $MARITALF.
		ETHNICITY ETHNICITYF.
		RACE RACEF.
		RACERETH RACERETHF.
		MONTH MONTHF.
		DAY DAYF.
		DX_TYPE1 DXTYPEF.
		DX_TYPE2 DXTYPEF.
		DX_TYPE3 DXTYPEF.
		DX_TYPE4 DXTYPEF.
		DX_TYPE5 DXTYPEF.
		DX_TYPE6 DXTYPEF.
		DX_TYPE7 DXTYPEF.
		DX_TYPE8 DXTYPEF.
		DX_TYPE9 DXTYPEF.
		DX_TYPE10 DXTYPEF.
		DX_TYPE11 DXTYPEF.
		DX_TYPE12 DXTYPEF.
		DX_TYPE13 DXTYPEF.
		DX_TYPE14 DXTYPEF.
		DX_TYPE15 DXTYPEF.
		DX_TYPE16 DXTYPEF.
		DX_TYPE17 DXTYPEF.
		DX_TYPE18 DXTYPEF.
		DX_TYPE19 DXTYPEF.
		DX_TYPE20 DXTYPEF.
		DX_TYPE21 DXTYPEF.
		DX_TYPE22 DXTYPEF.
		DX_TYPE23 DXTYPEF.
		DX_TYPE24 DXTYPEF.
		DX_TYPE25 DXTYPEF.
		DX_TYPE26 DXTYPEF.
		DX_TYPE27 DXTYPEF.
		DX_TYPE28 DXTYPEF.
		DX_TYPE29 DXTYPEF.
		DX_TYPE30 DXTYPEF.
	;
RUN;

* Display Contents of Data File After Applying Labels and Formats;
PROC CONTENTS DATA=hc24;
RUN;
