log using namcs_hc_2024_stata.log, replace
cd c:\namcshc2024
clear
set mem 20000

*Read in Stata Dataset
use namcshc2024_stata

*Define Value Labels
label define AGEF 89 "89+"  
label define AGEGROUPF  -9 "Missing" 1 "Less than 18 years" 2 "18-44 years" 3 "45-64 years" 4 "65 years or more"          
label define AGEMONTHF  -9 "Missing"  -7 "Not applicable, patient 1 year or older" 1 "1 month" 2 "2 months" 3 "3 months" 4 "4 months" 5 "5 months" 6 "6 months" 7 "7 months" 8 "8 months" 9 "9 months" 10 "10 months" 11 "11 months"
label define SEXF  -9 "Missing" 1 "Male" 2 "Female"
label define DAYF -9 "Missing" 1 "Sunday" 2 "Monday" 3 "Tuesday" 4 "Wednesday" 5 "Thursday" 6 "Friday" 7 "Saturday"
label define MONTHF  -9 "Missing" 1 "January" 2 "February" 3 "March" 4 "April" 5 "May" 6  "June" 7 "July" 8 "August" 9 "September" 10 "October" 11 "November" 12  "December"
label define ETHNICITYF -9 "Missing" 1 "Hispanic or Latino" 2 "Not Hispanic or Latino" 
label define RACEF  -9 "Missing" 1 "Asian" 2 "Black or African American" 3 "White" 4 "Other" 
label define RACERETHF -9 "Missing" 1 "White, non-Hispanic" 2 "Black, non-Hispanic" 3 "Hispanic" 4 "Other, non-Hispanic"
label define DXTYPEF -9 "Missing" 1 "Primary" 2 " Non-Primary"

*Assign Value Labels
label values DAY DAYF
label values MONTH MONTHF
label values AGE AGEF
label values AGE_GROUP AGEGROUPF
label values AGE_U1_MONTH AGEMONTHF
label values ETHNICITY ETHNICITYF
label values RACE RACEF
label values RACERETH RACERETHF
label values SEX SEXF
label values DX_TYPE1 DXTYPEF
label values DX_TYPE2 DXTYPEF
label values DX_TYPE3 DXTYPEF
label values DX_TYPE4 DXTYPEF
label values DX_TYPE5 DXTYPEF
label values DX_TYPE6 DXTYPEF
label values DX_TYPE7 DXTYPEF
label values DX_TYPE8 DXTYPEF
label values DX_TYPE9 DXTYPEF
label values DX_TYPE10 DXTYPEF
label values DX_TYPE11 DXTYPEF
label values DX_TYPE12 DXTYPEF
label values DX_TYPE13 DXTYPEF
label values DX_TYPE14 DXTYPEF
label values DX_TYPE15 DXTYPEF
label values DX_TYPE16 DXTYPEF
label values DX_TYPE17 DXTYPEF
label values DX_TYPE18 DXTYPEF
label values DX_TYPE19 DXTYPEF
label values DX_TYPE20 DXTYPEF
label values DX_TYPE21 DXTYPEF
label values DX_TYPE22 DXTYPEF
label values DX_TYPE23 DXTYPEF
label values DX_TYPE24 DXTYPEF
label values DX_TYPE25 DXTYPEF
label values DX_TYPE26 DXTYPEF
label values DX_TYPE27 DXTYPEF
label values DX_TYPE28 DXTYPEF
label values DX_TYPE29 DXTYPEF
label values DX_TYPE30 DXTYPEF

*Describe Contents of Data File
describe

*Location of Log
*log file is stored in namcs_hc_2024_stata.log

log close
