/*
PROGRAM: nehrs2024_puf_format.SAS 
PURPOSE: PROC FORMAT STATEMENT FOR NEHRS 2024 PUBLIC USE FILE DATA */;

PROC FORMAT;
value dispemrf
1='Eligible respondent, complete';

value EHRNAME
1='Allscripts'
2='athenahealth'
3='Cerner'
4='eClinical Works'
5='Epic'
6='Meditech'
7='Modernizing Medicine'
8='NextGen'
9='Practice Fusion'
10='Greenway'
11='Other'
12='Unknown'
-9='Blank'
-7='Not applicable';

value settingpf
	1="Solo or group practice"
	2="Not solo or group practice";

value numlocpf
	-9="Blank"
	1="1 location"
	2="2 locations"
	3="3 or more locations";

value psizecatpf
	-9="Blank"
	1="1 physician"
	2="2-3 physicians"
	3="4-10 physicians"
	4="11-50 physicians"
	5="More than 50 physicians";

value speccat 
	1='Primary care specialty' 2='Surgical specialty' 3='Medical specialty';
	
value page50f
	1='Under 50 years' 2='50+ years';


*from the original interview data list;
VALUE PHYID
11000101-43167715='Valid range for live data collection'
;

VALUE BOXF
0='Box is not marked'
1='Box is marked'
;

VALUE IPAPHO
1='Yes'
2='No'
3="Don't know (EV=-8)"
-7='Not applicable'
-8="Don't know"                                                                                                           
-9='Blank'
;

VALUE MCAIDINS
1='Yes'
2='No'
3="Don't know (EV=-8)"                                                                                                      
-7='Not applicable'
-8="Don't know"
-9='Blank'
;

VALUE MCAIDINS2F
1='Yes'
2='No'
3="Don't know (EV=-8)"
-7='Not applicable'
-8="Don't know" 
-9='Blank'
;

VALUE MCAREINS
1='Yes'
2='No'
3="Don't know (EV=-8)"                                                                                                      
-7='Not applicable'
-8="Don't know"
-9='Blank'
;

VALUE MCAREINS2F
1='Yes'
2='No'
3="Don't know (EV=-8)"                                                                                                      
-7='Not applicable'
-8="Don't know"
-9='Blank'
;

VALUE OWNS1F
1='Physician or physician group'
2='Insurance company, health plan, or HMO'
3='Community health center'
4='Medical / Academic health center'
5='Other hospital'
6='Other health care corporation'
7='Other'
-9='Blank'
;

VALUE EMEDREC
1='Yes'
2='No'
3="Don't know (EV=-8)"
-8="Don't know"
-9='Blank'
;

VALUE HHSMU
1='Yes'
2='No'
3="Don't know (EV=-8)"
-8="Don't know"
-7='Not applicable'
-9='Blank'
;

VALUE EHRSAT
1='Very satisfied'
2='Somewhat satisfied'
3="Neither satisfied nor dissatisfied"
4= 'Somewhat dissatisfied'
5= 'Very dissatisfied'
6= 'Not applicable'
-7='Not applicable, no EHR'
-9='Blank'
;

VALUE SDHSN
1='Yes, routinely'
2='Yes, but not routinely'
3='No'
4="Don't know (EV=-8)"
-7='Not applicable'
-8="Don't know"
-9='Blank'
;

VALUE SN_BUTTON
1='Often'
2='Sometimes'
3='Rarely' 
4= 'Never'  
5="Don't know (EV=-8)"
-7='Not applicable'
-8="Don't know"
-9='Blank'
;

VALUE SN_NOTE
1='Often'
2='Sometimes'
3='Rarely' 
4= 'Never'  
5="Don't know (EV=-8)"
-7='Not applicable'
-8="Don't know"
-9='Blank'
;

VALUE SN_DIAG
1='Often'
2='Sometimes'
3='Rarely' 
4= 'Never'  
5="Don't know (EV=-8)"
-7='Not applicable'
-8="Don't know"
-9='Blank'
;

VALUE SN_NONELEC
1='Often'
2='Sometimes'
3='Rarely' 
4= 'Never'  
5="Don't know (EV=-8)"
-7='Not applicable'
-8="Don't know"
-9='Blank'
;

VALUE HSNSSO
1='Often'
2='Sometimes'
3='Rarely' 
4= 'Never'  
5="Don't know (EV=-8)"
-7='Not applicable'
-8="Don't know"
-9='Blank'
;

VALUE HSNCDM
1='Often'
2='Sometimes'
3='Rarely' 
4= 'Never'  
5="Don't know (EV=-8)"
-7='Not applicable'
-8="Don't know"
-9='Blank'
;

VALUE TELEMEDICINE
1='Yes'
2='No'
3="Don't know (EV=-8)"
-8="Don't know" 
-9='Blank'
;

VALUE TELEMEDTOOL1F
0='Box is not marked' 
1='Box is marked' 
-7= 'Not applicable'
;

VALUE TELEMEDTOOL2F
0='Box is not marked' 
1='Box is marked' 
-7= 'Not applicable'
;

VALUE TELEMEDTOOL3F
0='Box is not marked' 
1='Box is marked' 
-7= 'Not applicable'
;

VALUE TELEMEDTOOL4F
0='Box is not marked' 
1='Box is marked' 
-7= 'Not applicable'
;

VALUE TELEMEDTOOL5F
0='Box is not marked' 
1='Box is marked' 
-7= 'Not applicable'
;

VALUE METHSEHRFREQ
1='Often'
2='Sometimes'
3='Rarely' 
4= 'Never'  
5="Don't know (EV=-8)"
-8="Don't know"
-9='Blank'
;

VALUE METHREHRFREQ
1='Often'
2='Sometimes'
3='Rarely' 
4= 'Never'  
5="Don't know (EV=-8)"
-8="Don't know"
-9='Blank'
;

VALUE PHAPHI
1='Yes'
2='No'
3="Don't know (EV=-8)"
4="Not applicable"
-8="Don't know"
-9='Blank'
;

VALUE PHA1F
0='Box is not marked'
1='Box is marked'
-7='Not applicable'
;

VALUE PHA2F
0='Box is not marked'
1='Box is marked'
-7='Not applicable'
;

VALUE PHA3F
0='Box is not marked'
1='Box is marked'
-7='Not applicable'
;

VALUE PHA4F
0='Box is not marked'
1='Box is marked'
-7='Not applicable'
;

VALUE NSEARCHFREQ
1='Often'
2='Sometimes'
3='Rarely'
4='Never'
5="Don't know (EV=-8)"
-8="Don't know"
-9='Blank'
;

VALUE INTPHI
1='Yes'
2='No'
3="Don't know (EV=-8)"
4="Not applicable"
-8="Dont know"
-9='Blank'
;

VALUE CINPOC
1='Often'
2='Sometimes'
3='Rarely'
4='Never'
5="Don't know (EV=-8)"
6='I do not see patients outside my medical organization'
-8="Don't know"
-9='Blank'
;

VALUE EUSEPHIOUT
1='Often'
2='Sometimes'
3='Rarely'
4='Never'
5="Don't know (EV=-8)"
-8="Don't know"
-9='Blank'
;

VALUE EXTINFO_EFF
1='Very'                                                                                      
2='Somewhat'                                                                                             
3='Not at all'                                                                    
4='Not applicable' 
5="Don't know (EV=-8)"
-8="Don't know" 
-9='Blank'
;

VALUE EXTINFO_SCN
1='Often'
2='Sometimes'
3='Rarely'
4='Never'
5="Don't know (EV=-8)"
-8="Don't know"
-9='Blank'
;

VALUE EXTINFO_PORT
1='Often'
2='Sometimes'
3='Rarely'
4='Never'
5="Don't know (EV=-8)"
-8="Don't know"
-9='Blank'
;

VALUE EXTINFO_INT
1='Often'
2='Sometimes'
3='Rarely'
4='Never'
5="Don't know (EV=-8)"
-8="Don't know"
-9='Blank'
;

VALUE EXTINFO_REC
1='To a great extent'
2='To some extent'
3='Not at all'
4='Not applicable' 
-9='Blank'
;

VALUE EXTINFO_KEY
1='To a great extent'
2='To some extent'
3='Not at all'
4='Not applicable' 
-9='Blank'
;

VALUE EXTINFO_LOW
1='To a great extent'
2='To some extent'
3='Not at all'
4='Not applicable' 
-9='Blank'
;

VALUE EXTINFO_OTH
1='To a great extent'
2='To some extent'
3='Not at all'
4='Not applicable' 
-9='Blank'
;

VALUE HIEQOC
1='Strongly agree' 
2='Somewhat agree'
3='Somewhat disagree'
4='Strongly disagree'
5='Not applicable'
-9='Blank'
;

VALUE HIEEFF
1='Strongly agree' 
2='Somewhat agree'
3='Somewhat disagree'
4='Strongly disagree'
5='Not applicable'
-9='Blank'
;

VALUE HIEPRVRXER
1='Strongly agree' 
2='Somewhat agree'
3='Somewhat disagree'
4='Strongly disagree'
5='Not applicable'
-9='Blank'
;

VALUE HIECARE
1='Strongly agree' 
2='Somewhat agree'
3='Somewhat disagree'
4='Strongly disagree'
5='Not applicable'
-9='Blank'
;

VALUE HIEDUPTEST
1='Strongly agree' 
2='Somewhat agree'
3='Somewhat disagree'
4='Strongly disagree'
5='Not applicable'
-9='Blank'
;

VALUE LACKCAP
1='Yes'
2='No'
3="Don't know  (EV=-8)"
4='Not applicable'
-8="Don't know" 
-9='Blank'
;

VALUE ITSTAFF
1='Yes'
2='No'
3="Don't know (EV=-8)"
4='Not applicable'
-8="Don't know" 
-9='Blank'
;

VALUE HIECOSTOUT
1='Yes'
2='No'
3="Don't know (EV=-8)"
4= 'Not applicable'
-8="Don't know" 
-9='Blank'
;

VALUE MULPORTOUT
1='Yes'
2='No'
3="Don't know (EV=-8)"
4= 'Not applicable'
-8="Don't know" 
-9='Blank'
;

VALUE SSRSTRDT
1='Fully or primarily automated' 
2='Mix of automated and manual process'
3='Fully or primarily manual'
4='We do not report this type of information'
5="Don't know (EV=-8)"
-8="Don't know"
-9='Blank'
;

VALUE IRRSTRDT
1='Fully or primarily automated' 
2='Mix of automated and manual process'
3='Fully or primarily manual'
4='We do not report this type of information'
5="Don't know (EV=-8)"
-8="Don't know"
-9='Blank'
;

VALUE ECRSTRDT
1='Fully or primarily automated' 
2='Mix of automated and manual process'
3='Fully or primarily manual'
4='We do not report this type of information'
5="Don't know (EV=-8)"
-8="Don't know"
-9='Blank'
;

VALUE PHRSTRDT
1='Fully or primarily automated' 
2='Mix of automated and manual process'
3='Fully or primarily manual'
4='We do not report this type of information'
5="Don't know (EV=-8)"
-8="Don't know"
-9='Blank'
;

VALUE WCOMPEMR
1='The physician to whom it was addressed'
2='Office staff'
3='Other'
-9='Blank'
;

VALUE COMPTYPE
1='Mail'
2='Web'
3='Help Desk'
4='Tracing'
-7='Not applicable'

;

VALUE WAVECOMP
1='1st mailing'
2='2nd mailing'
3='3rd mailing'
4='Web'
5='Help Desk'
6='No data for this participant'
7='Tracing'
-9='Blank'
;


RUN;
