#########################################################################
##       R PROGRAM: PSE_estimate_LLM-3-a.R
##
##         PROJECT: Evaluation of multiple-encounter population size
##                  estimators
##
##     DESCRIPTION: Estimate population sizes from simulated samples
##                  using loglinear models as implemented in the
##                  Rcapture package
##
##                  Mt, Mbh and Mht samples
##
##      WRITTEN BY: Steve Gutreuter, CDC/CGH/DGHT Statistics, Estimation
##                                   and Modeling Team
##                  sgutreuter@cdc.gov
##
##            DATE: 2021-03-02
##
#########################################################################
library(Rcapture)
#########################################################################
## Log session information
#########################################################################
sessionInfo()
#########################################################################
## Define file paths
#########################################################################
basepath <- file.path(Sys.getenv("PROJ"), "PSE/PSEsim")
workpath <- file.path(basepath, "R")
datapath <- file.path(basepath, "data")
setwd(workpath)
#########################################################################
## Source functions and get data
#########################################################################
source(file.path(workpath, "PSE_sim_functions.R"))
dataname <- file.path(datapath, "PSEsimSamples.Rdata")
load(dataname)
#########################################################################
## loglinear model fitting to independent homogeneous capture
## probabilities
#########################################################################
## test <- llm.estimate(data = Mbht.1K.200, events = 2:5,
##                      nreps = 1)
## print(test)
## Mbht data
t.start0 <- t.start <- Sys.time()
llm.Mbht.10K.200 <- llm.estimate(data = Mbht.10K.200, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
###
(t.start <- Sys.time() )
llm.Mbht.1K.025 <- llm.estimate(data = Mbht.1K.025, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mbht.1K.050 <- llm.estimate(data = Mbht.1K.050, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mbht.1K.100 <- llm.estimate(data = Mbht.1K.100, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mbht.1K.150 <- llm.estimate(data = Mbht.1K.150, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mbht.1K.200 <- llm.estimate(data = Mbht.1K.200, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
###
(t.start <- Sys.time() )
llm.Mbht.20K.025 <- llm.estimate(data = Mbht.20K.025, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mbht.20K.050 <- llm.estimate(data = Mbht.20K.050, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mbht.20K.100 <- llm.estimate(data = Mbht.20K.100, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mbht.20K.150 <- llm.estimate(data = Mbht.20K.150, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mbht.20K.200 <- llm.estimate(data = Mbht.20K.200, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
## Total elapsed time
Sys.time() - t.start0
rm(t.start, t.start0)
#########################################################################
## Save the results
#########################################################################
save(llm.Mbht.10K.200,
     llm.Mbht.1K.025, llm.Mbht.1K.050, llm.Mbht.1K.100,
     llm.Mbht.1K.150, llm.Mbht.1K.200,
     llm.Mbht.20K.025, llm.Mbht.20K.050, llm.Mbht.20K.100,
     llm.Mbht.20K.150, llm.Mbht.20K.200,
     file = file.path(datapath, "LLM_estimates-3-a.Rdata"))
cgwtools::lsdata(file.path(datapath, "LLM_estimates-3-a.Rdata"))
################################   END of FILE   ########################
