#########################################################################
##       R PROGRAM: PSE_estimate_LLM-1-a.R
##
##         PROJECT: Evaluation of multiple-encounter population size
##                  estimators
##
##     DESCRIPTION: Estimate population sizes from simulated samples
##                  using loglinear models as implemented in the
##                  Rcapture package
##
##                  Mh and Mb samples
##
##      WRITTEN BY: Steve Gutreuter, CDC/CGH/DGHT Statistics, Estimation
##                                   and Modeling Team
##                  sgutreuter@cdc.gov
#########################################################################
library(Rcapture)
#########################################################################
## Log session information
#########################################################################
sessionInfo()
#########################################################################
## Define file paths
#########################################################################
basepath <- file.path(Sys.getenv("PROJ"), "PSE/PSEsim")
workpath <- file.path(basepath, "R")
datapath <- file.path(basepath, "data")
setwd(workpath)
#########################################################################
## Source functions and get data
#########################################################################
source(file.path(workpath, "PSE_sim_functions.R"))
dataname <- file.path(datapath, "PSEsimSamples.Rdata")
attach(dataname)
cgwtools::lsdata(file.path(datapath, "PSEsimSamples.Rdata"))
#########################################################################
## loglinear model fitting to independent homogeneous capture
## probabilities
#########################################################################
## test <- llm.estimate(data = Mh.1K.200, events = 2:5,
##                      nreps = 1)
## print(test)
t.start0 <- t.start <- Sys.time()
## Mh data
(t.start <- Sys.time() )
llm.Mh.1K.025 <- llm.estimate(data = Mh.1K.025, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time())
llm.Mh.1K.050 <- llm.estimate(data = Mh.1K.050, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mh.1K.100 <- llm.estimate(data = Mh.1K.100, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mh.1K.150 <- llm.estimate(data = Mh.1K.150, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mh.1K.200 <- llm.estimate(data = Mh.1K.200, events = 2:5,
                              nreps = 400, progress = FALSE)
Sys.time() - t.start
##
(t.start <- Sys.time() )
llm.Mh.10K.200 <- llm.estimate(data = Mh.10K.200, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
##
(t.start <- Sys.time() )
llm.Mh.20K.025 <- llm.estimate(data = Mh.20K.025, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mh.20K.050 <- llm.estimate(data = Mh.20K.050, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mh.20K.100 <- llm.estimate(data = Mh.20K.100, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mh.20K.150 <- llm.estimate(data = Mh.20K.150, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
llm.Mh.20K.200 <- llm.estimate(data = Mh.20K.200, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
## Mb data
(t.start <- Sys.time() )
llm.Mb.1K.025 <- llm.estimate(data = Mb.1K.025, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mb.1K.050 <- llm.estimate(data = Mb.1K.050, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mb.1K.100 <- llm.estimate(data = Mb.1K.100, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mb.1K.150 <- llm.estimate(data = Mb.1K.150, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mb.1K.200 <- llm.estimate(data = Mb.1K.200, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
##
(t.start <- Sys.time() )
llm.Mb.10K.200 <- llm.estimate(data = Mb.10K.200, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
##
(t.start <- Sys.time() )
llm.Mb.20K.025 <- llm.estimate(data = Mb.20K.025, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mb.20K.050 <- llm.estimate(data = Mb.20K.050, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mb.20K.100 <- llm.estimate(data = Mb.20K.100, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mb.20K.150 <- llm.estimate(data = Mb.20K.150, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
(t.start <- Sys.time() )
llm.Mb.20K.200 <- llm.estimate(data = Mb.20K.200, events = 2:5,
                               nreps = 400, progress = FALSE)
Sys.time() - t.start
## Total elapsed time
Sys.time() - t.start0
rm(t.start, t.start0)
#########################################################################
## Save the results
#########################################################################
save(llm.Mh.10K.200,
     llm.Mh.1K.025, llm.Mh.1K.050, llm.Mh.1K.100, llm.Mh.1K.150,
     llm.Mh.1K.200,
     llm.Mh.20K.025, llm.Mh.20K.050, llm.Mh.20K.100, llm.Mh.20K.150,
     llm.Mh.20K.200,
     llm.Mb.10K.200,
     llm.Mb.1K.025, llm.Mb.1K.050, llm.Mb.1K.100, llm.Mb.1K.150,
     llm.Mb.1K.200,
     llm.Mb.20K.025, llm.Mb.20K.050, llm.Mb.20K.100, llm.Mb.20K.150,
     llm.Mb.20K.200,
     file = file.path(datapath, "LLM_estimates-1-a.Rdata"))
################################   END of FILE   ########################
