/*********************************************************************
APRIL 19, 2010  3:58 PM
 
 THIS IS AN EXAMPLE OF A PROGRAM THAT CAN BE USED TO READ IN THE
 NNHS_04 ASCII FILE AND RUN FREQUENCIES ON THE NNHS_04 
 PUBLIC-USE LINKED MORTALITY FILE.
 
 NOTE: THE FORMAT DEFINITIONS GIVEN BELOW WILL RESULT IN
       PROCEDURE OUTPUT SHOWING VALUES THAT HAVE BEEN
       GROUPED AS THEY ARE SHOWN IN THE FILE LAYOUT
       DOCUMENTATION.
 
NNHS_04 Linked Mortality-2010

TOTAL RECORDS: 13,507


TO DOWNLOAD AND SAVE THE NNHS_04 PUBLIC-USE LINKED MORTALITY FILE TO YOUR 
HARD DRIVE, FOLLOW THESE STEPS:

*STEP 1: DESIGNATE A FOLDER ON YOUR HARD DRIVE TO DOWNLOAD THE NNHS_04
         PUBLIC-USE LINKED MORTALITY FILE. IN THIS EXAMPLE, THE DATA WILL
         BE SAVED TO: 'C:\PUBLIC USE DATA\NNHS_04\DATA'

*STEP 2: TO DOWLOAD THE NNHS_04 PUBLIC-USE LINKED MORTALITY FILE, GO TO THE WEB SITE: 
	     http://www.cdc.gov/nchs/data_access/data_linkage/mortality/nnhs04_linkage_public_use.htm

		 SCROLL DOWN TO THE LINK NAMED "NNHS_04 Linked Mortality Public-use Data file".

		 RIGHT CLICK ON THE LINK AND SELECT "Save Target as...". A "Save as" SCREEN 
		 WILL APPEAR AND YOU WILL NEED TO SELECT AND INPUT A LOCATION WHERE TO SAVE 
	     THE DATA FILE ON YOUR HARD DRIVE.

		 IT IS ALSO IMPORTANT THAT THE BOX "Save Type as" reads ".dat Document".
		 THIS WILL ENSURE THAT THE DATA FILE IS SAVED TO YOUR HARD DRIVE IN THE 
	     CORRECT FORMAT. 

	  	 IN THIS EXAMPLE, WE SAVE THE DATA FILE IN THE FOLDER 'C:\PUBLIC USE DATA\NNHS_04\DATA' 
	     AND SAVE THE DATA FILE AS "nnhs04_mort_public_use_2010.dat".



***********************************************************************/
# delimit ;
clear;
set mem 200m;

/*READ IN THE NNHS 2004 PUBLIC USE LINKED MORTALITY ASCII FILE */
/* INPUT ALL VARIABLES */
infix 
resnum		1-6 
eligstat 		7 
mortstat 		8 
mortsrce_ndi	9
mortsrce_ssa	10
perday_adm		11-15
causeavl		16 
str ucod_113 	17-19 
diabetes 		20 
hyperten 		21 
hipfract 		22 

using nnhs04_mort_public_use_2010.dat;

/* DEFINE VARIABLE LABELS */
label variable resnum 		"resident record (case) number";
label variable eligstat 	"eligibility status for mortality follow-up";
label variable mortstat 	"final mortality status"; 
label variable mortsrce_ndi 	"mortality source: NDI match";
label variable mortsrce_ssa 	"mortality source: SSA information";
label variable perday_adm 	"person days of follow-up from admission date";
label variable causeavl 	"cause of death data available";
label variable ucod_113 	"underlying cause of death 113 groups all years (icd-10)";
label variable diabetes 	"diabetes flag from multiple cause of death (mcod)";
label variable hyperten 	"hypertension flag from multiple cause of death (mcod)";
label variable hipfract 	"hip fracture flag from multiple cause of death (mcod)";


/* DEFINE VALUE LABELS FOR REPORTS */
label define eligfmt
1	"Eligible"
2	"Under age 18"
3	"Ineligible"
;

label define mortfmt
0	"Assumed alive"
1	"Assumed Deceased"
/* .	"Ineligible or under age 18" */
;

label define msrcendifmt
0	"No"
1	"Yes"	
/* .	"Ineligible or under age 18" */
;

label define msrcessafmt
0	"No"
1	"Yes"	
/* .	"Ineligible or under age 18" */
;

label define causefmt
0	"No"
1	"Yes"	
/* .	"Ineligible, under age 18 or assumed alive" */
;

label define flagfmt
0	"No"
1	"Yes- listed as a multiple cause of death"	
/* .	"Ineligible, under age 18, assumed alive or no cause data" */
;

/* ASSOCIATE VARIABLES WITH FORMAT VALUES */
label values eligstat	eligfmt;
label values mortstat	mortfmt;
label values mortsrce_ndi msrcendifmt;
label values mortsrce_ssa msrcessafmt;
label values causeavl	causefmt;
label values diabetes	flagfmt;
label values hyperten	flagfmt;
label values hipfract	flagfmt;

/* DISPLAY OVERALL DESCRIPTION OF FILE */
describe;

/*RUN FREQUENCIES- UNWEIGHTED */
tabulate eligstat;
tabulate mortstat;
tabulate mortsrce_ndi; 
tabulate mortsrce_ssa; 
tabulate causeavl; 
tabulate ucod_113; 
tabulate diabetes;
tabulate hyperten; 
tabulate hipfract; 

/* DATA FILE IS STORED IN NNHS04PMORT.DTA */
save nnhs04pmort, replace;

#delimit cr


