*********************************************************************
APRIL 09, 2010  10:58 AM
 
 THIS IS AN EXAMPLE OF A PROGRAM THAT CAN BE USED TO READ IN THE
 NNHS_04 ASCII FILE AND RUN FREQUENCIES ON THE NNHS_04 
 PUBLIC-USE LINKED MORTALITY FILE.
 
 NOTE: THE FORMAT DEFINITIONS GIVEN BELOW WILL RESULT IN
       PROCEDURE OUTPUT SHOWING VALUES THAT HAVE BEEN
       GROUPED AS THEY ARE SHOWN IN THE FILE LAYOUT
       DOCUMENTATION.
 
NNHS_04 Linked Mortality-2010

TOTAL RECORDS: 13,507
***********************************************************************

TO DOWNLOAD AND SAVE THE NNHS_04 PUBLIC-USE LINKED MORTALITY FILE TO YOUR 
HARD DRIVE, FOLLOW THESE STEPS:

*STEP 1: DESIGNATE A FOLDER ON YOUR HARD DRIVE TO DOWNLOAD THE NNHS_04
         PUBLIC-USE LINKED MORTALITY FILE. IN THIS EXAMPLE, THE DATA WILL
         BE SAVED TO: 'C:\PUBLIC USE DATA\NNHS_04\DATA'

*STEP 2: TO DOWLOAD THE NNHS_04 PUBLIC-USE LINKED MORTALITY FILE, GO TO THE WEB SITE: 
	     http://www.cdc.gov/nchs/data_access/data_linkage/mortality/nnhs04_linkage_public_use.htm

		 SCROLL DOWN TO THE LINK NAMED "NNHS_04 Linked Mortality Public-use Data file".

		 RIGHT CLICK ON THE LINK AND SELECT "Save Target as...". A "Save as" SCREEN 
		 WILL APPEAR AND YOU WILL NEED TO SELECT AND INPUT A LOCATION WHERE TO SAVE 
	     THE DATA FILE ON YOUR HARD DRIVE.

		 IT IS ALSO IMPORTANT THAT THE BOX "Save Type as" reads ".dat Document".
		 THIS WILL ENSURE THAT THE DATA FILE IS SAVED TO YOUR HARD DRIVE IN THE 
	     CORRECT FORMAT. 

	  	 IN THIS EXAMPLE, WE SAVE THE DATA FILE IN THE FOLDER 'C:\PUBLIC USE DATA\NNHS_04\DATA' 
	     AND SAVE THE DATA FILE AS "nnhs04_mort_public_use_2010.dat".



***********************************************************************;

* DEFINE VARIABLE VALUES FOR REPORTS;

PROC FORMAT;

  VALUE ELIGFMT
    1 = "Eligible"
    2 = "Under age 18"
    3 = "Ineligible" ;

  VALUE MORTFMT
    0 = "Assumed alive"
    1 = "Assumed deceased"
    . = "Ineligible or under age 18";

  VALUE MRSRCFMT
  	0 = "No"
	1 = "Yes"
	. = "Ineligible, under age 18 or assumed alive" ;

 VALUE CAUSEFMT
  	0 = "No"
	1 = "Yes"
	. = "Ineligible, under age 18 or assumed alive";

  VALUE FLAGFMT
    0 = "No"
    1 = "Yes"  
    . = "Ineligible, under age 18, assumed alive or no cause data";

RUN ;

*CREATE A TEMPORARY SAS WORK DATASET;
DATA NNHS04;
	
  INFILE "C:\PUBLIC USE DATA\NNHS_04\DATA\NNHS04_MORT_PUBLIC_USE_2010.DAT"   LRECL = 22 PAD ; 
	
	INPUT
 	RESNUM		1 - 6
	ELIGSTAT		7
	MORTSTAT		8
	MORTSRCE_NDI	9
	MORTSRCE_SSA	10
	PERDAY_ADM		11-15
	CAUSEAVL		16
	UCOD_113		$ 17-19
	DIABETES		20
   	HYPERTEN		21
	HIPFRACT		22
    ; 

   * ASSOCIATE VARIABLES WITH FORMAT VALUES;
	FORMAT    
		ELIGSTAT 		ELIGFMT.  
		MORTSTAT 		MORTFMT.
     	MORTSRCE_NDI 	MRSRCFMT.
     	MORTSRCE_SSA 	MRSRCFMT.
		CAUSEAVL 		CAUSEFMT.
		DIABETES 		FLAGFMT.          
		HYPERTEN 		FLAGFMT.  
		HIPFRACT 		FLAGFMT. 
     ;


   * LABEL VARIABLES;
   	LABEL
		RESNUM   		= 'Resident Record (Case) Number'
	 	ELIGSTAT   		= 'Eligibility Status for Mortality Follow-up'
	 	MORTSTAT   		= 'Final Mortality Status'
	 	MORTSRCE_NDI	= 'Mortality Source: NDI Match'
	 	MORTSRCE_SSA	= 'Mortality Source: SSA Information'
	 	PERDAY_ADM 		= 'Person Days of Follow-up from Admission Date'
		CAUSEAVL		= 'Cause of Death Data Available'
	 	UCOD_113   		= 'Underlying Cause Of Death 113 Groups Recode All Years (ICD-10)'
	 	DIABETES   		= 'Diabetes Flag from Multiple Cause of Death (MCOD)'
	 	HYPERTEN   		= 'Hypertension Flag from Multiple Cause of Death (MCOD)'
	 	HIPFRACT   		= 'Hip Fracture Flag from Multiple Cause of Death (MCOD)'
	 ;
    
RUN;

OPTIONS PAGENO=1;
*RUN PROC CONTENTS;
PROC CONTENTS DATA=NNHS04; 
RUN;

*RUN FREQUENCIES;
PROC FREQ DATA=NNHS04;
	TABLES 
		ELIGSTAT
		MORTSTAT 
		MORTSRCE_NDI
		MORTSRCE_SSA
		UCOD_113 
		CAUSEAVL
		DIABETES
		HYPERTEN 
		HIPFRACT 
	/ MISSING;
	TITLE1 "NNHS_04 PUBLIC-USE LINKED MORTALITY FILE";
	TITLE2 "UNWEIGHTED FREQUENCIES";



* USER NOTE: TO SEE UNFORMATTED VALUES IN THE FREQUENCY PROCEDURE, 
  UNCOMMENT THE STATEMENT "FORMAT _ALL_" BELOW ;
* FORMAT _ALL_;
RUN;



