/*********************************************************************
March 16, 2010 2:09 PM
 
 THIS IS AN EXAMPLE OF A PROGRAM THAT CAN BE USED TO READ IN THE 
 NHIS 1990 PUBLIC-USE LINKED MORTALITY ASCII FILE AND RUN 
 FREQUENCIES ON THE DATA.
 
 NOTE: THE FORMAT DEFINITIONS GIVEN BELOW WILL RESULT IN
       PROCEDURE OUTPUT SHOWING VALUES THAT HAVE BEEN
       GROUPED AS THEY ARE SHOWN IN THE FILE LAYOUT
       DOCUMENTATION
 
NHIS Linked Mortality--2010

Total Records, NHIS 1990: 119,631

TO DOWNLOAD AND SAVE THE NHIS 1990 PUBLIC-USE LINKED MORTALITY FILE
TO YOUR HARD DRIVE, FOLLOW THESE STEPS:

*STEP 1: DESIGNATE A FOLDER ON YOUR HARD DRIVE TO DOWNLOAD THE NHIS
         1990 PUBLIC-USE LINKED MORTALITY FILE. IN THIS EXAMPLE, 
         THE DATA WILL BE SAVED TO: 'C:\Public Use Data\NHIS\DATA'

*STEP 2: DOWNLOAD THE ASCII DATA FROM THE NCHS WEB SITE.
         GO TO THE NCHS WEB SITE (LINK BELOW) AND DOWNLOAD THE NHIS
         1990 PUBLIC-USE LINKED MORTALITY ASCII FILE TO THE FOLDER
        'C:\Public Use Data\NHIS\DATA'
  

 ftp://ftp.cdc.gov/pub/Health_Statistics/NCHS/datalinkage/linked_mortality/nhis90_mort_public_use_2010.dat

 NOTES:

THIS PROGRAM ASSUMES THAT THE ASCII DATA FILE IS IN STATA"S WORKING
DIRECTORY.  AN EXAMPLE OF HOW TO CHANGE THE WORKING DIRECTORY 
WITHIN STATA IS THE FOLLOWING COMMAND: cd "C:\Public Use Data\nhis\data"

*********************************************************************/
# delimit ;
clear;
set mem 200m;

/*READ IN THE NHIS 1990 PUBLIC-USE LINKED MORTALITY ASCII FILE */
/* INPUT ALL VARIABLES */
infix 
str publicid 	1-14 
str publicid_2	15-28
eligstat 		29
mortstat 		30
mortsrce_ndi 	31
mortsrce_ssa 	32
mortsrce_cms 	33
dodqtr 		34 
dodyear		35-38
causeavl 		39 
str ucod_113 	40-42 
diabetes 		43 
hyperten 		44 
hipfract 		45 
wgt_new 		46-53
sa_wgt_new 		54-61 
using nhis90_mort_public_use_2010.dat;

/* DEFINE VARIABLE LABELS */
label variable publicid "public-use id";
label variable publicid2 "alternate nhis public-use id for 1997-2003 NHIS years";
label variable eligstat "eligibility status for mortality follow-up";
label variable mortstat "final mortality status"; 
label variable mortsrce_ndi "mortality source: NDI match";
label variable mortsrce_ssa "mortality source: SSA information";
label variable mortsrce_cms	"mortality source: CMS information";
label variable dodqtr  "quarter of death";
label variable dodyear "year of death";
label variable causeavl "cause of death data available";
label variable ucod_113 "underlying cause of death 113 groups all years (icd-10)";
label variable diabetes "diabetes flag from multiple cause of death (mcod)";
label variable hyperten "hypertension flag from multiple cause of death (mcod)";
label variable hipfract "hip fracture flag from multiple cause of death (mcod)";
label variable wgt_new  "weight adjusted for ineligible respondents-person level sample weight";
label variable sa_wgt_new  "weight adjusted for ineligible respondents-sample adult sample weight";

/* DEFINE VALUE LABELS FOR REPORTS */

label define eligfmt
1	"Eligible"
2	"Under age 18, not available for public release "
3	"Ineligible"
;

label define mortfmt
0	"Assumed alive"
1	"Assumed Deceased"
/* .	"Ineligible for mortality follow-up or under age 18" */
;
label define msrcendifmt
0	"No"
1	"Yes"	
/* .	"Ineligible for mortality follow-up, under age 18, or assumed alive" */
;

label define msrcessafmt
0	"No"
1	"Yes"	
/* .	"Ineligible for mortality follow-up, under age 18, or assumed alive" */
;

label define msrcecmsfmt
0	"No"
1	"Yes"	
9	" Not applicable"
/* .	"Ineligible for mortality follow-up, under age 18, or assumed alive" */
;

label define qtrfmt
1	"January-March"
2	"April-June"	
3	"July-September"
4	"October-December"
/* .	" Ineligible for mortality follow-up, under age 18, or assumed alive "*/
;

label define causefmt
0	"No"
1	"Yes"	
/* .	"Ineligible for mortality follow-up, under age 18, or assumed alive" */
;

label define flagfmt
0	"No"
1	"Yes- listed as a multiple cause of death"	
/* .	"Ineligible for mortality follow-up, under age 18, assumed alive, or cause of death code not available" */
;

/* ASSOCIATE VARIABLES WITH FORMAT VALUES */
label values eligstat	eligfmt;
label values mortstat	mortfmt;	
label values mortsrce_ndi msrcendifmt;
label values mortsrce_ssa msrcessafmt;
label values mortsrce_cms msrcecmsfmt;
label values dodqtr	qtrfmt;
label values causeavl	causefmt;
label values diabetes	flagfmt;
label values hyperten	flagfmt;
label values hipfract	flagfmt;

/* DISPLAY OVERALL DESCRIPTION OF FILE */
describe;

/*RUN FREQUENCIES- UNWEIGHTED */
tabulate eligstat;
tabulate mortstat;
tabulate mortsrce_ndi; 
tabulate mortsrce_ssa; 
tabulate mortsrce_cms; 
tabulate dodqtr; 
tabulate dodyear;
tabulate causeavl; 
tabulate ucod_113; 
tabulate diabetes;
tabulate hyperten; 
tabulate hipfract; 

/* DATA FILE IS STORED IN NHIS90PMORT.DTA */
save nhis90pmort, replace;

#delimit cr


