/****************************************************************************************************
March 16, 2010  2:24 PM
 
 THIS IS AN EXAMPLE OF A PROGRAM THAT CAN BE USED TO READ IN THE 
 NHANES III PUBLIC-USE LINKED MORTALITY ASCII FILE AND RUN 
 FREQUENCIES ON THE DATA.
 
 NOTE: THE FORMAT DEFINITIONS GIVEN BELOW WILL RESULT IN
       PROCEDURE OUTPUT SHOWING VALUES THAT HAVE BEEN
       GROUPED AS THEY ARE SHOWN IN THE FILE LAYOUT
       DOCUMENTATION
 
NHANES III Linked Mortality--2010

TOTAL RECORDS: 33,994

TO DOWNLOAD AND SAVE THE NHANES III PUBLIC-USE LINKED MORTALITY FILE TO
YOUR HARD DRIVE, FOLLOW THESE STEPS:

*STEP 1: DESIGNATE A FOLDER ON YOUR HARD DRIVE TO DOWNLOAD THE NHANES III PUBLIC-USE LINKED 
	   MORTALITY FILES. IN THIS EXAMPLE, THE DATA WILL BE SAVED TO: 'C:\Public Use Data\NHANES3\DATA'

*STEP 2: TO DOWLOAD THE NHANES III PUBLIC-USE LINKED MORTALITY FILE, GO TO THE WEB SITE: 
	   http://www.cdc.gov/nchs/data_access/data_linkage/mortality/nhanes3_linkage_public_use.htm.

	   SCROLL DOWN TO THE LINK NAMED "NHANES III Linked Mortality Public-use Data file".

	   RIGHT CLICK ON THE LINK AND SELECT "Save Target as...". A "Save as" SCREEN WILL APPEAR AND 
	   YOU WILL NEED TO SELECT AND INPUT A LOCATION WHERE TO SAVE THE DATA FILE ON YOUR HARD DRIVE.

	   IT IS ALSO IMPORTANT THAT THE BOX "Save Type as" reads ".dat Document". THIS WILL ENSURE THAT 
	   THE DATA FILE IS SAVED TO YOUR HARD DRIVE IN THE CORRECT FORMAT. 

	   IN THIS EXAMPLE, WE SAVE THE DATA FILE IN THE FOLDER 'C:\PUBLIC USE DATA\NHANES3\DATA' AND 
	   SAVE THE DATA FILE AS "nhanes3_mort_public_use.dat".

 NOTES:

THIS PROGRAM ASSUMES THAT THE ASCII DATA FILE IS IN STATA"S WORKING DIRECTORY.  AN EXAMPLE OF 
HOW TO CHANGE THE WORKING DIRECTORY WITHIN STATA IS THE FOLLOWING COMMAND: 
cd "C:\Public Use Data\nhanes3\data" 

*******************************************************************************************************/
# delimit ;
clear;
set mem 200m;

/*READ IN THE NHANES III PUBLIC USE LINKED MORTALITY ASCII FILE */
/* INPUT ALL VARIABLES */
infix 
seqn			1-5 
eligstat 		6 
mortstat 		7 
mortsrce_dc		8
mortsrce_ndi	9
mortsrce_ssa	10
mortsrce_cms	11
permth_int		12-14
permth_exm		15-17
causeavl		18 
str ucod_113 	19-21 
diabetes 		22 
hyperten 		23 
hipfract 		24 
using nhanes3_mort_public_use_2010.dat;

/* DEFINE VARIABLE LABELS */
label variable seqn 		"NHANES III Sequence number";
label variable eligstat 	"eligibility status for mortality follow-up";
label variable mortstat 	"final mortality status"; 
label variable mortsrce_dc 	"mortality source: death certificate match";
label variable mortsrce_ndi 	"mortality source: NDI match";
label variable mortsrce_ssa 	"mortality source: SSA information";
label variable mortsrce_cms	"mortality source: CMS information";
label variable permth_int 	"person months of follow-up from interview date";
label variable permth_exm 	"person months of follow-up from MEC/Home exam date";
label variable causeavl 	"cause of death data available";
label variable ucod_113 	"underlying cause of death 113 groups all years (icd-10)";
label variable diabetes 	"diabetes flag from multiple cause of death (mcod)";
label variable hyperten 	"hypertension flag from multiple cause of death (mcod)";
label variable hipfract 	"hip fracture flag from multiple cause of death (mcod)";


/* DEFINE VALUE LABELS FOR REPORTS */

label define eligfmt
1	"Eligible"
2	" Under age 17, not available for public release "
3	"Ineligible, insufficient data for matching"
;

label define mortfmt
0	"Assumed alive"
1	"Assumed Deceased"
/* .	" Ineligible for mortality follow-up or under age 17" */
;

label define msrcedcfmt
0	"No"
1	"Yes"	
/* .	" Ineligible for mortality follow-up, under age 17, or assumed alive" */
;

label define msrcendifmt
0	"No"
1	"Yes"	
/* .	" Ineligible for mortality follow-up, under age 17, or assumed alive" */
;

label define msrcessafmt
0	"No"
1	"Yes"	
/* .	" Ineligible for mortality follow-up, under age 17, or assumed alive" */
;

label define msrcecmsfmt
0	"No"
1	"Yes"	
/* .	" Ineligible for mortality follow-up, under age 17, or assumed alive" */
;

label define causefmt
0	"No"
1	"Yes"	
/* .	" Ineligible for mortality follow-up, under age 17, or assumed alive" */
;

label define flagfmt
0	"No"
1	"Yes- listed as a multiple cause of death"	
/* .	" Ineligible for mortality follow-up, under age 17, assumed alive, or cause of death code not available " */
;

/* ASSOCIATE VARIABLES WITH FORMAT VALUES */
label values eligstat	eligfmt;
label values mortstat	mortfmt;
label values mortsrce_dc msrcedcfmt;
label values mortsrce_ndi msrcendifmt;
label values mortsrce_ssa msrcessafmt;
label values mortsrce_cms msrcecmsfmt;
label values causeavl	causefmt;
label values diabetes	flagfmt;
label values hyperten	flagfmt;
label values hipfract	flagfmt;

/* DISPLAY OVERALL DESCRIPTION OF FILE */
describe;

/*RUN FREQUENCIES- UNWEIGHTED */
tabulate eligstat;
tabulate mortstat;
tabulate mortsrce_dc; 
tabulate mortsrce_ndi; 
tabulate mortsrce_ssa; 
tabulate mortsrce_cms; 
tabulate causeavl; 
tabulate ucod_113; 
tabulate diabetes;
tabulate hyperten; 
tabulate hipfract; 

/* DATA FILE IS STORED IN NHANES3PMORT.DTA */
save nhanes3pmort, replace;

#delimit cr


