*********************************************************************
FEBRUARY 16, 2010  9:55 AM
 
 THIS IS AN EXAMPLE OF A PROGRAM THAT CAN BE USED TO READ IN THE
 NHANES III ASCII FILE AND RUN FREQUENCIES ON THE NHANES III 
 PUBLIC-USE LINKED MORTALITY FILE.
 
 NOTE: THE FORMAT DEFINITIONS GIVEN BELOW WILL RESULT IN
       PROCEDURE OUTPUT SHOWING VALUES THAT HAVE BEEN
       GROUPED AS THEY ARE SHOWN IN THE FILE LAYOUT
       DOCUMENTATION.
 
NHANES III Linked Mortality-2010

TOTAL RECORDS: 33,994
***********************************************************************

TO DOWNLOAD AND SAVE THE NHANES III PUBLIC-USE LINKED MORTALITY FILE TO YOUR 
HARD DRIVE, FOLLOW THESE STEPS:

*STEP 1: DESIGNATE A FOLDER ON YOUR HARD DRIVE TO DOWNLOAD THE NHANES III
         PUBLIC-USE LINKED MORTALITY FILE. IN THIS EXAMPLE, THE DATA WILL
         BE SAVED TO: 'C:\PUBLIC USE DATA\NHANES3\DATA'

*STEP 2: TO DOWLOAD THE NHANES III PUBLIC-USE LINKED MORTALITY FILE, GO TO THE WEB SITE: 
	     http://www.cdc.gov/nchs/data_access/data_linkage/mortality/nhis_linkage_public_use.htm

		 SCROLL DOWN TO THE LINK NAMED "NHANES III Linked Mortality Public-use Data file".

		 RIGHT CLICK ON THE LINK AND SELECT "Save Target as...". A "Save as" SCREEN 
		 WILL APPEAR AND YOU WILL NEED TO SELECT AND INPUT A LOCATION WHERE TO SAVE 
	     THE DATA FILE ON YOUR HARD DRIVE.

		 IT IS ALSO IMPORTANT THAT THE BOX "Save Type as" reads ".dat Document".
		 THIS WILL ENSURE THAT THE DATA FILE IS SAVED TO YOUR HARD DRIVE IN THE 
	     CORRECT FORMAT. 

	  	 IN THIS EXAMPLE, WE SAVE THE DATA FILE IN THE FOLDER 'C:\PUBLIC USE DATA\NHANES3\DATA' 
	     AND SAVE THE DATA FILE AS "nhanes3_mort_public_use_2010.dat".



***********************************************************************;

* DEFINE VARIABLE VALUES FOR REPORTS;

PROC FORMAT;

  VALUE ELIGFMT
    1 = "Eligible"
    2 = "Under age 17"
    3 = "Ineligible" ;

  VALUE MORTFMT
    0 = "Assumed alive"
    1 = "Assumed deceased"
    . = "Ineligible or under age 17";

  VALUE MRSRCFMT
  	0 = "No"
	1 = "Yes"
	. = "Ineligible, under age 17 or assumed alive" ;

 VALUE CAUSEFMT
  	0 = "No"
	1 = "Yes"
	. = "Ineligible, under age 17 or assumed alive";

  VALUE FLAGFMT
    0 = "No"
    1 = "Yes"  
    . = "Ineligible, under age 17, assumed alive or no cause data";

RUN ;

*CREATE A TEMPORARY SAS WORK DATASET;
DATA NHANES3;

	INFILE "C:\PUBLIC USE DATA\NHANES3\DATA\NHANES3_MORT_PUBLIC_USE_2010.DAT"   LRECL = 24 PAD ; 
	INPUT
 	SEQN			1 - 5
	ELIGSTAT		6
	MORTSTAT		7
	MORTSRCE_DC		8
	MORTSRCE_NDI	9
	MORTSRCE_SSA	10
	MORTSRCE_CMS	11
	PERMTH_INT		12-14
	PERMTH_EXM		15-17
	CAUSEAVL		18
	UCOD_113		$ 19-21
	DIABETES		22
   	HYPERTEN		23
	HIPFRACT		24
    ; 

   * ASSOCIATE VARIABLES WITH FORMAT VALUES;
	FORMAT    
		ELIGSTAT 		ELIGFMT.  
		MORTSTAT 		MORTFMT.
     	MORTSRCE_DC 	MRSRCFMT.
     	MORTSRCE_NDI 	MRSRCFMT.
     	MORTSRCE_SSA 	MRSRCFMT.
     	MORTSRCE_CMS 	MRSRCFMT.
		CAUSEAVL 		CAUSEFMT.
		DIABETES 		FLAGFMT.          
		HYPERTEN 		FLAGFMT.  
		HIPFRACT 		FLAGFMT. 
     ;


   * LABEL VARIABLES;
   	LABEL
		SEQN       		= 'NHANES III Sequence Number'
	 	ELIGSTAT   		= 'Eligibility Status for Mortality Follow-up'
	 	MORTSTAT   		= 'Final Mortality Status'
	 	MORTSRCE_DC		= 'Mortality Source: Death Certificate Match'
	 	MORTSRCE_NDI	= 'Mortality Source: NDI Match'
	 	MORTSRCE_SSA	= 'Mortality Source: SSA Information'
	 	MORTSRCE_CMS	= 'Mortality Source: CMS Information'
	 	PERMTH_INT 		= 'Person Months of Follow-up from Interview Date'
	 	PERMTH_EXM		= 'Person Months of Follow-up from MEC/Home Exam Date'
		CAUSEAVL		= 'Cause of Death Data Available'
	 	UCOD_113   		= 'Underlying Cause Of Death 113 Groups Recode All Years (ICD-10)'
	 	DIABETES   		= 'Diabetes Flag from Multiple Cause of Death (MCOD)'
	 	HYPERTEN   		= 'Hypertension Flag from Multiple Cause of Death (MCOD)'
	 	HIPFRACT   		= 'Hip Fracture Flag from Multiple Cause of Death (MCOD)'
	 ;
    
RUN;

OPTIONS PAGENO=1;
*RUN PROC CONTENTS;
PROC CONTENTS DATA=NHANES3; 
RUN;

*RUN FREQUENCIES;
PROC FREQ DATA=NHANES3;
	TABLES 
		ELIGSTAT
		MORTSTAT 
		MORTSRCE_DC
		MORTSRCE_NDI
		MORTSRCE_SSA
		MORTSRCE_CMS
		UCOD_113 
		CAUSEAVL
		DIABETES
		HYPERTEN 
		HIPFRACT 
	/ MISSING;
	TITLE1 "NHANES III PUBLIC-USE LINKED MORTALITY FILE";
	TITLE2 "UNWEIGHTED FREQUENCIES";

* USER NOTE: TO SEE UNFORMATTED VALUES IN THE FREQUENCY PROCEDURE, 
  UNCOMMENT THE STATEMENT "FORMAT _ALL_" BELOW ;
* FORMAT _ALL_;
RUN;



