/*********************************************************************
April 14, 2010  12:30 PM
 
 THIS IS AN EXAMPLE OF A PROGRAM THAT CAN BE USED TO READ IN THE 
 LSOA II PUBLIC-USE LINKED MORTALITY ASCII FILE AND RUN 
 FREQUENCIES ON THE DATA.
 
 NOTE: THE FORMAT DEFINITIONS GIVEN BELOW WILL RESULT IN
       PROCEDURE OUTPUT SHOWING VALUES THAT HAVE BEEN
       GROUPED AS THEY ARE SHOWN IN THE FILE LAYOUT
       DOCUMENTATION
 
LSOA II Linked Mortality--2010

Total Records: 9447
***********************************************************************

TO DOWNLOAD AND SAVE THE LSOA II PUBLIC-USE LINKED MORTALITY FILE TO
YOUR HARD DRIVE, FOLLOW THESE STEPS:

*STEP 1: DESIGNATE A FOLDER ON YOUR HARD DRIVE TO DOWNLOAD THE LSOA II
         PUBLIC USE LINKED MORTALITY FILE. IN THIS EXAMPLE, THE DATA WILL
         BE SAVED TO: 'C:\Public Use Data\LSOA II\DATA'

*STEP 2: GO TO THE NCHS WEB SITE (LINK BELOW) AND DOWNLOAD THE LSOA II
         PUBLIC-USE LINKED MORTALITY ASCII FILE TO THE FOLDER 
         'C:\Public Use Data\LSOA II\DATA'

ftp://ftp.cdc.gov/pub/Health_Statistics/NCHS/datalinkage/linked_mortality/LSOA2_MORT_PUBLIC_USE_2010.DAT

***********************************************************************/

# delimit ;
clear;
set mem 200m;

/*READ IN THE LSOA II PUBLIC USE LINKED MORTALITY ASCII FILE */
/* INPUT ALL VARIABLES */
infix 
str publicid	1-14 
eligstat 		15 
mortstat 		16 
mortsrce_ndi	17
mortsrce_ssa	18
mortsrce_cms	19
mortsrce_dcl	20
dodqtr      	21
dodyear     	22-25
causeavl		26 
str ucod_113 	27-29 
diabetes 		30 
hyperten 		31 
hipfract 		32 
using lsoa2_mort_public_use_2010.dat;


/* DEFINE VARIABLE LABELS */
label variable publicid 	"LSOA II Public-use ID";
label variable eligstat 	"eligibility status for mortality follow-up";
label variable mortstat 	"final mortality status"; 
label variable mortsrce_ndi 	"mortality source: NDI match";
label variable mortsrce_ssa 	"mortality source: SSA information";
label variable mortsrce_cms	"mortality source: CMS information";
label variable mortsrce_dcl 	"mortality source: data collection";
label variable dodqtr 		"quarter of death";
label variable dodyear 		"year of death";
label variable causeavl 	"cause of death data available";
label variable ucod_113 	"underlying cause of death 113 groups all years (icd-10)";
label variable diabetes 	"diabetes flag from multiple cause of death (mcod)";
label variable hyperten 	"hypertension flag from multiple cause of death (mcod)";
label variable hipfract 	"hip fracture flag from multiple cause of death (mcod)";


/* DEFINE VALUE LABELS FOR REPORTS */

label define eligfmt
1	"Eligible"
3	"Ineligible, insufficient data for matching"
;

label define mortfmt
0	"Assumed alive"
1	"Assumed Deceased"
/* .	"Ineligible" */
;

label define msrcefmt
0	"No"
1	"Yes"	
9	"Not Applicable"
/* .	"Ineligible or assumed alive" */
;

label define qrtfmt
1	"January - March"
2	"April   - June"
3	"July    - September"
4	"October - December" 
9	"Unavailable"
/* .  "Ineligible or assumed alive" */
;

label define dodyfmt
9999	"Unavailable"
/* .  "Ineligible or assumed alive"*/
;

label define causefmt
0	"No"
1	"Yes"	
/* .	"Ineligible or assumed alive" */
;

label define flagfmt
0	"No"
1	"Yes"	
/* .	"Ineligible, assumed alive, or cause of death code not available" */
;

/* ASSOCIATE VARIABLES WITH FORMAT VALUES */
label values eligstat	eligfmt;
label values mortstat	mortfmt;
label values mortsrce_ndi msrcefmt;
label values mortsrce_ssa msrcefmt;
label values mortsrce_cms msrcefmt;
label values mortsrce_dcl msrcefmt;
label values dodqtr 	qrtfmt;
label values dodyear 	dodyfmt;
label values causeavl	causefmt;
label values diabetes	flagfmt;
label values hyperten	flagfmt;
label values hipfract	flagfmt;

/* DISPLAY OVERALL DESCRIPTION OF FILE */
describe;

/*RUN FREQUENCIES- UNWEIGHTED */
tabulate eligstat;
tabulate mortstat;
tabulate mortsrce_ndi; 
tabulate mortsrce_ssa; 
tabulate mortsrce_cms; 
tabulate mortsrce_dcl; 
tabulate dodqtr; 
tabulate dodyear; 
tabulate causeavl; 
tabulate ucod_113; 
tabulate diabetes;
tabulate hyperten; 
tabulate hipfract; 

/* DATA FILE IS STORED IN LSOA2PMORT.DTA */
save lsoa2pmort, replace;

#delimit cr


