*********************************************************************
MARCH 11, 2010  12:30 PM
 
 THIS IS AN EXAMPLE OF A PROGRAM THAT CAN BE USED TO READ IN THE 
 LSOA II PUBLIC-USE LINKED MORTALITY ASCII FILE AND RUN 
 FREQUENCIES ON THE DATA.
 
 NOTE: THE FORMAT DEFINITIONS GIVEN BELOW WILL RESULT IN
       PROCEDURE OUTPUT SHOWING VALUES THAT HAVE BEEN
       GROUPED AS THEY ARE SHOWN IN THE FILE LAYOUT
       DOCUMENTATION
 
LSOA II Linked Mortality--2010

Total Records: 9447
***********************************************************************

TO DOWNLOAD AND SAVE THE LSOA II PUBLIC-USE LINKED MORTALITY FILE TO
YOUR HARD DRIVE, FOLLOW THESE STEPS:

*STEP 1: DESIGNATE A FOLDER ON YOUR HARD DRIVE TO DOWNLOAD THE LSOA II
         PUBLIC USE LINKED MORTALITY FILE. IN THIS EXAMPLE, THE DATA WILL
         BE SAVED TO: 'C:\Public Use Data\LSOA II\DATA'

*STEP 2: GO TO THE NCHS WEB SITE (LINK BELOW) AND DOWNLOAD THE LSOA II
         PUBLIC-USE LINKED MORTALITY ASCII FILE TO THE FOLDER 
         'C:\Public Use Data\LSOA II\DATA'

ftp://ftp.cdc.gov/pub/Health_Statistics/NCHS/datalinkage/linked_mortality/LSOA2_MORT_PUBLIC_USE_2010.DAT

***********************************************************************;

* DEFINE VARIABLE VALUES FOR REPORTS;

PROC FORMAT;

  VALUE ELIGFMT
    1 = "Eligible"
    3 = "Ineligible" ;

  VALUE MORTFMT
    0 = "Assumed alive"
    1 = "Assumed deceased"
    . = "Ineligible";

  VALUE MRSRCFMT
  	0 = "No"
	1 = "Yes"
	9 = "Not Applicable"
	. = "Ineligible or assumed alive";

 VALUE CAUSEFMT
  	0 = "No"
	1 = "Yes"
	. = "Ineligible or assumed alive";

  VALUE QRTFMT
    1 = "January - March"
    2 = "April   - June"
    3 = "July    - September"
    4 = "October - December" 
    9 = "Unavailable"
    . = "Ineligible or assumed alive";

  VALUE DODYFMT
  9999 = "Unavailable"
    . = "Ineligible or assumed alive";

  VALUE FLAGFMT
    0 = "No"
    1 = "Yes"  
    . = "Ineligible, assumed alive or no cause data";




RUN ;

*READ IN THE LSOA II PUBLIC USE LINKED MORTALITY ASCII FILE;

DATA LSOA2;

 INFILE "C:\Public Use Data\LSOA II\DATA\LSOA2_MORT_PUBLIC_USE_2010.DAT"  LRECL = 32 PAD MISSOVER ;


   * INPUT ALL VARIABLES;
   INPUT
     	PUBLICID 		$  1 - 14
    	ELIGSTAT    	15
    	MORTSTAT   		16
		MORTSRCE_NDI	17
		MORTSRCE_SSA	18
		MORTSRCE_CMS	19
		MORTSRCE_DCL	20
     	DODQTR      	21
     	DODYEAR     	22 - 25
		CAUSEAVL		26
     	UCOD_113		$ 27 - 29
     	DIABETES    	30
     	HYPERTEN    	31
     	HIPFRACT    	32
     ;



   * DEFINE VARIABLE LABELS;
  
LABEL 	PUBLICID 		=	"LSOA II Public-use ID"
		ELIGSTAT		=	'Eligibility Status for Mortality Follow-up'
		MORTSTAT		=	'Final Mortality Status'
		MORTSRCE_NDI	=	'Mortality Source: NDI Match'
		MORTSRCE_SSA	=	'Mortality Source: SSA Information'
		MORTSRCE_CMS	=	'Mortality Source: CMS Information'
		MORTSRCE_DCL	=	'Mortality Source: Data Collection'
		DODQTR			=	"Quarter of Death"
		DODYEAR			=	'Year of Death'
		CAUSEAVL    	=   'Cause of Death Data Available'
		UCOD_113		=	'Underlying Cause Of Death 113 Groups Recode All Years (ICD-10)'
		DIABETES		=	'Diabetes Flag from Multiple Cause of Death (MCOD)'
		HYPERTEN		=	'Hypertension Flag from Multiple Cause of Death (MCOD)'
		HIPFRACT		=	'Hip Fracture Flag from Multiple Cause of Death (MCOD)'
     ;

   * ASSOCIATE VARIABLES WITH FORMAT VALUES;
   FORMAT    
		ELIGSTAT 		ELIGFMT.          
		MORTSTAT 		MORTFMT.
     	MORTSRCE_NDI 	MRSRCFMT.
     	MORTSRCE_SSA 	MRSRCFMT.
     	MORTSRCE_CMS 	MRSRCFMT.
     	MORTSRCE_DCL 	MRSRCFMT.
		CAUSEAVL 		CAUSEFMT.
     	DODQTR   		QRTFMT.           
		DODYEAR  		DODYFMT.
     	DIABETES 		FLAGFMT.          
		HYPERTEN 		FLAGFMT. 
     	HIPFRACT 		FLAGFMT.;
RUN;

OPTIONS PAGENO=1;

*RUN FREQUENCIES;
PROC FREQ DATA=LSOA2;
  TABLES
		ELIGSTAT
		MORTSTAT 
		MORTSRCE_NDI
		MORTSRCE_SSA
		MORTSRCE_CMS
		MORTSRCE_DCL
		DODQTR 
		DODYEAR
		CAUSEAVL
		UCOD_113 
		DIABETES
		HYPERTEN 
		HIPFRACT 

   / LIST MISSING;
TITLE1 "LSOA II PUBLIC-USE LINKED MORTALITY FILE";
TITLE2 "UNWEIGHTED FREQUENCIES";

  * USER NOTE: TO SEE UNFORMATTED VALUES IN THE FREQUENCY PROCEDURE, 
    UNCOMMENT THE STATEMENT "FORMAT _ALL_" BELOW ;
  * FORMAT _ALL_;
RUN;

